/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.operator.window.WindowType;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupBySessionParameter
extends GroupByParameter {
    private final long timeInterval;

    public GroupBySessionParameter(long timeInterval) {
        super(WindowType.SESSION_WINDOW);
        this.timeInterval = timeInterval;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((long)this.timeInterval, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.timeInterval, (OutputStream)stream);
    }

    public static GroupByParameter deserialize(ByteBuffer buffer) {
        long timeInterval = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return new GroupBySessionParameter(timeInterval);
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.timeInterval == ((GroupBySessionParameter)obj).timeInterval;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeInterval);
    }
}

