/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MergeSortNode
extends MultiChildProcessNode {
    private final OrderByParameter mergeOrderParameter;
    private final List<String> outputColumns;

    public MergeSortNode(PlanNodeId id, OrderByParameter mergeOrderParameter, List<String> outputColumns) {
        super(id);
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
    }

    public MergeSortNode(PlanNodeId id, List<PlanNode> children, OrderByParameter mergeOrderParameter, List<String> outputColumns) {
        super(id, children);
        this.mergeOrderParameter = mergeOrderParameter;
        this.outputColumns = outputColumns;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    @Override
    public PlanNode clone() {
        return new MergeSortNode(this.getPlanNodeId(), this.getMergeOrderParameter(), this.outputColumns);
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new MergeSortNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)), this.getMergeOrderParameter(), this.outputColumns);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumns;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.MERGE_SORT.serialize(byteBuffer);
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (ByteBuffer)byteBuffer);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.MERGE_SORT.serialize(stream);
        this.mergeOrderParameter.serializeAttributes(stream);
        ReadWriteIOUtils.write((int)this.outputColumns.size(), (OutputStream)stream);
        for (String column : this.outputColumns) {
            ReadWriteIOUtils.write((String)column, (OutputStream)stream);
        }
    }

    public static MergeSortNode deserialize(ByteBuffer byteBuffer) {
        OrderByParameter orderByParameter = OrderByParameter.deserialize(byteBuffer);
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); columnSize > 0; --columnSize) {
            outputColumns.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new MergeSortNode(planNodeId, orderByParameter, outputColumns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MergeSortNode that = (MergeSortNode)o;
        return Objects.equals(this.mergeOrderParameter, that.getMergeOrderParameter());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mergeOrderParameter);
    }

    public String toString() {
        return "MergeSort-" + this.getPlanNodeId();
    }
}

