/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.ternary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class TernaryExpression
extends Expression {
    protected final Expression firstExpression;
    protected final Expression secondExpression;
    protected final Expression thirdExpression;

    public Expression getFirstExpression() {
        return this.firstExpression;
    }

    public Expression getSecondExpression() {
        return this.secondExpression;
    }

    public Expression getThirdExpression() {
        return this.thirdExpression;
    }

    protected TernaryExpression(Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        this.firstExpression = firstExpression;
        this.secondExpression = secondExpression;
        this.thirdExpression = thirdExpression;
    }

    protected TernaryExpression(ByteBuffer byteBuffer) {
        this.firstExpression = Expression.deserialize(byteBuffer);
        this.secondExpression = Expression.deserialize(byteBuffer);
        this.thirdExpression = Expression.deserialize(byteBuffer);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTernaryExpression(this, context);
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.firstExpression.isConstantOperand() && this.secondExpression.isConstantOperand() && this.thirdExpression.isConstantOperand();
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.firstExpression, this.secondExpression, this.thirdExpression);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        return this.firstExpression.isMappable(expressionTypes) && this.secondExpression.isMappable(expressionTypes) && this.thirdExpression.isMappable(expressionTypes);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.firstExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.secondExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.thirdExpression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.firstExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.secondExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.thirdExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.firstExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.secondExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.thirdExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    protected abstract String operator();

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.firstExpression, byteBuffer);
        Expression.serialize(this.secondExpression, byteBuffer);
        Expression.serialize(this.thirdExpression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.firstExpression, stream);
        Expression.serialize(this.secondExpression, stream);
        Expression.serialize(this.thirdExpression, stream);
    }
}

