/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.sys;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;

public class AuthorizerTask
implements IConfigTask {
    private final AuthorStatement authorStatement;
    private final AuthorizerManager authorizerManager = AuthorizerManager.getInstance();

    public AuthorizerTask(AuthorStatement authorStatement) {
        this.authorStatement = authorStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        if (this.authorStatement.getQueryType() == QueryType.WRITE) {
            return this.authorizerManager.operatePermission(this.authorStatement);
        }
        return this.authorizerManager.queryPermission(this.authorStatement);
    }
}

