/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TClusterParameters;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowVariablesTask
implements IConfigTask {
    private static void buildTSBlock(TsBlockBuilder builder, Binary parameter, Binary value) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(parameter);
        builder.getColumnBuilder(1).writeBinary(value);
        builder.declarePosition();
    }

    public static void buildTSBlock(TShowVariablesResp showVariablesResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showVariablesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        TClusterParameters clusterParameters = showVariablesResp.getClusterParameters();
        ShowVariablesTask.buildTSBlock(builder, new Binary("ClusterName"), new Binary(clusterParameters.getClusterName()));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataReplicationFactor"), new Binary(String.valueOf(clusterParameters.getDataReplicationFactor())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaReplicationFactor"), new Binary(String.valueOf(clusterParameters.getSchemaReplicationFactor())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataRegionConsensusProtocolClass"), new Binary(clusterParameters.getDataRegionConsensusProtocolClass()));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaRegionConsensusProtocolClass"), new Binary(clusterParameters.getSchemaRegionConsensusProtocolClass()));
        ShowVariablesTask.buildTSBlock(builder, new Binary("ConfigNodeConsensusProtocolClass"), new Binary(clusterParameters.getConfigNodeConsensusProtocolClass()));
        ShowVariablesTask.buildTSBlock(builder, new Binary("TimePartitionInterval"), new Binary(String.valueOf(clusterParameters.getTimePartitionInterval())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DefaultTTL(ms)"), new Binary(String.valueOf(clusterParameters.getDefaultTTL())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("ReadConsistencyLevel"), new Binary(String.valueOf(clusterParameters.getReadConsistencyLevel())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SchemaRegionPerDataNode"), new Binary(String.valueOf(clusterParameters.getSchemaRegionPerDataNode())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DataRegionPerDataNode"), new Binary(String.valueOf(clusterParameters.getDataRegionPerDataNode())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SeriesSlotNum"), new Binary(String.valueOf(clusterParameters.getSeriesPartitionSlotNum())));
        ShowVariablesTask.buildTSBlock(builder, new Binary("SeriesSlotExecutorClass"), new Binary(clusterParameters.getSeriesPartitionExecutorClass()));
        ShowVariablesTask.buildTSBlock(builder, new Binary("DiskSpaceWarningThreshold"), new Binary(String.valueOf(clusterParameters.getDiskSpaceWarningThreshold())));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowClusterParametersHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showClusterParameters();
    }
}

