/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

public class ColumnPaginationController {
    private final boolean isDisabled;
    private final boolean hasLimit;
    private long curLimit;
    private long curOffset;

    public ColumnPaginationController(long seriesLimit, long seriesOffset, boolean isDisabled) {
        this.isDisabled = isDisabled;
        this.hasLimit = seriesLimit > 0L;
        this.curLimit = seriesLimit;
        this.curOffset = seriesOffset;
    }

    public boolean hasCurOffset() {
        if (this.isDisabled) {
            return false;
        }
        return this.curOffset != 0L;
    }

    public boolean hasCurLimit() {
        if (this.isDisabled || !this.hasLimit) {
            return true;
        }
        return this.curLimit != 0L;
    }

    public void consumeOffset() {
        if (this.isDisabled) {
            return;
        }
        --this.curOffset;
    }

    public void consumeLimit() {
        if (this.isDisabled || !this.hasLimit) {
            return;
        }
        --this.curLimit;
    }
}

