/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeClientManager;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.VerifyMetadataException;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.sql.MeasurementNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.execution.operator.window.WindowType;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.mpp.plan.analyze.ConcatPathRewriter;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByConditionParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupBySessionParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByVariationParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.IntoPathDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByConditionComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupBySessionComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByVariationComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkTypeStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.PredicateRemoveNotRewriter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeVisitor
extends StatementVisitor<Analysis, MPPQueryContext> {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeVisitor.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final Expression deviceExpression = TimeSeriesOperand.constructColumnHeaderExpression("Device", TSDataType.TEXT);
    private static final Expression endTimeExpression = TimeSeriesOperand.constructColumnHeaderExpression("__endTime", TSDataType.INT64);
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public AnalyzeVisitor(IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    @Override
    public Analysis visitNode(StatementNode node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    public Analysis visitExplain(ExplainStatement explainStatement, MPPQueryContext context) {
        Analysis analysis = this.visitQuery(explainStatement.getQueryStatement(), context);
        analysis.setStatement(explainStatement);
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    @Override
    public Analysis visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        try {
            List<Object> outputExpressions;
            queryStatement.semanticCheck();
            PathPatternTree patternTree = new PathPatternTree();
            queryStatement = (QueryStatement)new ConcatPathRewriter().rewrite(queryStatement, patternTree);
            analysis.setStatement(queryStatement);
            logger.debug("[StartFetchSchema]");
            long startTime = System.nanoTime();
            ISchemaTree schemaTree = queryStatement.isGroupByTag() ? this.schemaFetcher.fetchSchemaWithTags(patternTree) : this.schemaFetcher.fetchSchema(patternTree);
            QueryMetricsManager.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
            logger.debug("[EndFetchSchema]");
            if (schemaTree.isEmpty()) {
                return this.finishQuery(queryStatement, analysis);
            }
            this.analyzeGlobalTimeFilter(analysis, queryStatement);
            if (queryStatement.isLastQuery()) {
                if (analysis.hasValueFilter()) {
                    throw new SemanticException("Only time filters are supported in LAST query");
                }
                this.analyzeOrderBy(analysis, queryStatement);
                ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
                for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
                    selectExpressions.add(resultColumn.getExpression());
                }
                this.analyzeLastSource(analysis, selectExpressions, schemaTree);
                analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
                this.analyzeDataPartition(analysis, queryStatement, schemaTree);
                return analysis;
            }
            if (queryStatement.isAlignByDevice()) {
                Set<PartialPath> deviceSet = this.analyzeFrom(queryStatement, schemaTree);
                outputExpressions = this.analyzeSelect(analysis, queryStatement, schemaTree, deviceSet);
                if (deviceSet.isEmpty()) {
                    return this.finishQuery(queryStatement, analysis);
                }
                this.analyzeDeviceToGroupBy(analysis, queryStatement, schemaTree, deviceSet);
                HashMap<String, Set<Expression>> deviceToAggregationExpressions = new HashMap<String, Set<Expression>>();
                this.analyzeHaving(analysis, queryStatement, schemaTree, deviceSet, deviceToAggregationExpressions);
                this.analyzeDeviceToAggregation(analysis, queryStatement, deviceToAggregationExpressions);
                analysis.setDeviceToAggregationExpressions(deviceToAggregationExpressions);
                this.analyzeDeviceToWhere(analysis, queryStatement, schemaTree, deviceSet);
                this.analyzeDeviceToSourceTransform(analysis, queryStatement);
                this.analyzeDeviceToSource(analysis, queryStatement);
                this.analyzeDeviceView(analysis, queryStatement, outputExpressions);
                this.analyzeInto(analysis, queryStatement, deviceSet, outputExpressions);
            } else {
                Map<Integer, List<Pair<Expression, String>>> outputExpressionMap = this.analyzeSelect(analysis, queryStatement, schemaTree);
                outputExpressions = new ArrayList();
                outputExpressionMap.values().forEach(outputExpressions::addAll);
                if (outputExpressions.isEmpty()) {
                    return this.finishQuery(queryStatement, analysis);
                }
                this.analyzeGroupBy(analysis, queryStatement, schemaTree);
                this.analyzeHaving(analysis, queryStatement, schemaTree);
                this.analyzeGroupByLevel(analysis, queryStatement, outputExpressionMap, outputExpressions);
                this.analyzeGroupByTag(analysis, queryStatement, outputExpressions);
                LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
                if (queryStatement.isOutputEndTime()) {
                    selectExpressions.add(endTimeExpression);
                }
                for (Pair pair : outputExpressions) {
                    selectExpressions.add((Expression)pair.left);
                }
                analysis.setSelectExpressions(selectExpressions);
                this.analyzeAggregation(analysis, queryStatement);
                this.analyzeWhere(analysis, queryStatement, schemaTree);
                this.analyzeSourceTransform(analysis, queryStatement);
                this.analyzeSource(analysis, queryStatement);
                this.analyzeInto(analysis, queryStatement, outputExpressions);
            }
            this.analyzeGroupByTime(analysis, queryStatement);
            this.analyzeFill(analysis, queryStatement);
            this.analyzeOutput(analysis, queryStatement, outputExpressions);
            this.analyzeDataPartition(analysis, queryStatement, schemaTree);
        }
        catch (StatementAnalyzeException e) {
            logger.warn("Meet error when analyzing the query statement: ", (Throwable)e);
            throw new StatementAnalyzeException("Meet error when analyzing the query statement: " + e.getMessage());
        }
        return analysis;
    }

    private Analysis finishQuery(QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
        }
        if (queryStatement.isLastQuery()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        }
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private void analyzeGlobalTimeFilter(Analysis analysis, QueryStatement queryStatement) {
        Object globalTimeFilter = null;
        boolean hasValueFilter = false;
        if (queryStatement.getWhereCondition() != null) {
            WhereCondition whereCondition = queryStatement.getWhereCondition();
            Expression predicate = whereCondition.getPredicate();
            Pair<Filter, Boolean> resultPair = ExpressionAnalyzer.extractGlobalTimeFilter(predicate, true, true);
            globalTimeFilter = (Filter)resultPair.left;
            if (globalTimeFilter != null) {
                globalTimeFilter = PredicateRemoveNotRewriter.rewrite((Filter)globalTimeFilter);
            }
            hasValueFilter = (Boolean)resultPair.right;
            predicate = ExpressionAnalyzer.evaluatePredicate(predicate);
            if (!hasValueFilter || predicate.getExpressionType().equals((Object)ExpressionType.CONSTANT) && Boolean.parseBoolean(predicate.getExpressionString())) {
                queryStatement.setWhereCondition(null);
            } else {
                whereCondition.setPredicate(predicate);
            }
        }
        if (queryStatement.isGroupByTime()) {
            GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
            GroupByFilter groupByFilter = this.initGroupByFilter(groupByTimeComponent);
            globalTimeFilter = globalTimeFilter == null ? groupByFilter : FilterFactory.and((Filter)globalTimeFilter, (Filter)groupByFilter);
        }
        analysis.setGlobalTimeFilter((Filter)globalTimeFilter);
        analysis.setHasValueFilter(hasValueFilter);
    }

    private void analyzeLastSource(Analysis analysis, List<Expression> selectExpressions, ISchemaTree schemaTree) {
        AbstractSet sourceExpressions;
        OrderByParameter orderByParameter = analysis.getMergeOrderParameter();
        if (orderByParameter != null && !orderByParameter.getSortItemList().isEmpty()) {
            List<SortItem> sortItemList = orderByParameter.getSortItemList();
            Preconditions.checkState((sortItemList.size() == 1 && sortItemList.get(0).getSortKey() == SortKey.TIMESERIES ? 1 : 0) != 0, (Object)"Last queries only support sorting by timeseries now.");
            boolean isAscending = sortItemList.get(0).getOrdering() == Ordering.ASC;
            sourceExpressions = new TreeSet((e1, e2) -> isAscending ? e1.toString().compareTo(e2.toString()) : e2.toString().compareTo(e1.toString()));
        } else {
            sourceExpressions = new LinkedHashSet<Expression>();
        }
        for (Expression selectExpression : selectExpressions) {
            sourceExpressions.addAll(ExpressionAnalyzer.removeWildcardInExpression(selectExpression, schemaTree));
        }
        analysis.setSourceExpressions(sourceExpressions);
    }

    private Map<Integer, List<Pair<Expression, String>>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        HashMap<Integer, List<Pair<Expression, String>>> outputExpressionMap = new HashMap<Integer, List<Pair<Expression, String>>>();
        boolean isGroupByLevel = queryStatement.isGroupByLevel();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), queryStatement.isLastQuery() || isGroupByLevel);
        HashSet<String> aliasSet = new HashSet<String>();
        int columnIndex = 0;
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            ArrayList<Pair> outputExpressions = new ArrayList<Pair>();
            boolean hasAlias = resultColumn.hasAlias();
            List<Expression> resultExpressions = ExpressionAnalyzer.removeWildcardInExpression(resultColumn.getExpression(), schemaTree);
            for (Expression expression : resultExpressions) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) break;
                if (isGroupByLevel) {
                    this.analyzeExpression(analysis, expression);
                    outputExpressions.add(new Pair((Object)expression, (Object)resultColumn.getAlias()));
                    queryStatement.getGroupByLevelComponent().updateIsCountStar(resultColumn.getExpression());
                } else {
                    Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(expression);
                    String alias = !Objects.equals(expressionWithoutAlias, expression) ? expression.getExpressionString() : null;
                    String string = alias = hasAlias ? resultColumn.getAlias() : alias;
                    if (hasAlias) {
                        if (aliasSet.contains(alias)) {
                            throw new SemanticException(String.format("alias '%s' can only be matched with one time series", alias));
                        }
                        aliasSet.add(alias);
                    }
                    this.analyzeExpression(analysis, expressionWithoutAlias);
                    outputExpressions.add(new Pair((Object)expressionWithoutAlias, (Object)alias));
                }
                paginationController.consumeLimit();
            }
            outputExpressionMap.put(columnIndex++, outputExpressions);
        }
        return outputExpressionMap;
    }

    private Set<PartialPath> analyzeFrom(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
        LinkedHashSet<PartialPath> deviceSet = new LinkedHashSet<PartialPath>();
        for (PartialPath devicePattern : devicePatternList) {
            deviceSet.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
        }
        return deviceSet;
    }

    private List<Pair<Expression, String>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, Set<PartialPath> deviceSet) {
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        HashMap<String, Set<Expression>> deviceToSelectExpressions = new HashMap<String, Set<Expression>>();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        HashSet<PartialPath> noMeasurementDevices = new HashSet<PartialPath>(deviceSet);
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            Expression selectExpression = resultColumn.getExpression();
            boolean hasAlias = resultColumn.hasAlias();
            LinkedHashMap<Expression, Map> measurementToDeviceSelectExpressions = new LinkedHashMap<Expression, Map>();
            for (PartialPath device : deviceSet) {
                List<Expression> selectExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(selectExpression, device, schemaTree);
                if (selectExpressionsOfOneDevice.isEmpty()) continue;
                noMeasurementDevices.remove(device);
                for (Expression expression2 : selectExpressionsOfOneDevice) {
                    Expression measurementExpression = ExpressionAnalyzer.getMeasurementExpression(expression2);
                    measurementToDeviceSelectExpressions.computeIfAbsent(measurementExpression, key -> new LinkedHashMap()).put(device.getFullPath(), ExpressionAnalyzer.removeAliasFromExpression(expression2));
                }
            }
            if (hasAlias && measurementToDeviceSelectExpressions.keySet().size() > 1) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
            }
            for (Expression measurementExpression : measurementToDeviceSelectExpressions.keySet()) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                Map deviceToSelectExpressionsOfOneMeasurement = (Map)measurementToDeviceSelectExpressions.get(measurementExpression);
                deviceToSelectExpressionsOfOneMeasurement.values().forEach(expression -> this.analyzeExpression(analysis, (Expression)expression));
                this.checkDataTypeConsistencyInAlignByDevice(analysis, new ArrayList<Expression>(deviceToSelectExpressionsOfOneMeasurement.values()));
                Expression measurementExpressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(measurementExpression);
                String alias = !Objects.equals(measurementExpressionWithoutAlias, measurementExpression) ? measurementExpression.getExpressionString() : null;
                alias = hasAlias ? resultColumn.getAlias() : alias;
                this.analyzeExpression(analysis, measurementExpressionWithoutAlias);
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)measurementExpressionWithoutAlias, (Object)alias));
                for (String deviceName : deviceToSelectExpressionsOfOneMeasurement.keySet()) {
                    Expression expression3 = (Expression)deviceToSelectExpressionsOfOneMeasurement.get(deviceName);
                    Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(expression3);
                    this.analyzeExpression(analysis, expressionWithoutAlias);
                    deviceToSelectExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(expressionWithoutAlias);
                }
                paginationController.consumeLimit();
            }
        }
        deviceSet.removeAll(noMeasurementDevices);
        analysis.setDeviceToSelectExpressions(deviceToSelectExpressions);
        return outputExpressions;
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        List<Expression> conJunctions = ExpressionAnalyzer.removeWildcardInFilter(queryStatement.getHavingCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true);
        Expression havingExpression = ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
        TSDataType outputType = this.analyzeExpression(analysis, havingExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setHavingExpression(havingExpression);
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, Set<PartialPath> deviceSet, Map<String, Set<Expression>> deviceToAggregationExpressions) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        Expression havingExpression = queryStatement.getHavingCondition().getPredicate();
        HashSet conJunctions = new HashSet();
        for (PartialPath device : deviceSet) {
            List<Expression> expressionsInHaving = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(havingExpression, device, schemaTree);
            conJunctions.addAll(expressionsInHaving.stream().map(ExpressionAnalyzer::getMeasurementExpression).collect(Collectors.toList()));
            for (Expression expression : expressionsInHaving) {
                LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                    this.analyzeExpression(analysis, aggregationExpression);
                    aggregationExpressions.add(aggregationExpression);
                }
                deviceToAggregationExpressions.computeIfAbsent(device.getFullPath(), key -> new LinkedHashSet()).addAll(aggregationExpressions);
            }
        }
        havingExpression = ExpressionUtils.constructQueryFilter(new ArrayList<Expression>(conJunctions));
        TSDataType outputType = this.analyzeExpression(analysis, havingExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setHavingExpression(havingExpression);
    }

    private void analyzeGroupByLevel(Analysis analysis, QueryStatement queryStatement, Map<Integer, List<Pair<Expression, String>>> outputExpressionMap, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isGroupByLevel()) {
            return;
        }
        GroupByLevelController groupByLevelController = new GroupByLevelController(queryStatement.getGroupByLevelComponent().getLevels());
        LinkedList groupedSelectExpressions = new LinkedList();
        for (List<Pair<Expression, String>> outputExpressionList : outputExpressionMap.values()) {
            LinkedHashSet<Expression> groupedSelectExpressionSet = new LinkedHashSet<Expression>();
            for (int i = 0; i < outputExpressionList.size(); ++i) {
                Pair<Expression, String> expressionAliasPair = outputExpressionList.get(i);
                boolean isCountStar = queryStatement.getGroupByLevelComponent().isCountStar(i);
                Expression groupedExpression = groupByLevelController.control(isCountStar, (Expression)expressionAliasPair.left, (String)expressionAliasPair.right);
                groupedSelectExpressionSet.add(groupedExpression);
            }
            groupedSelectExpressions.addAll(groupedSelectExpressionSet);
        }
        LinkedHashMap<Expression, Set<Expression>> groupByLevelExpressions = new LinkedHashMap<Expression, Set<Expression>>();
        if (queryStatement.hasHaving()) {
            Expression havingExpression = groupByLevelController.control(analysis.getHavingExpression());
            this.analyzeExpression(analysis, havingExpression);
            analysis.setHavingExpression(havingExpression);
            this.updateGroupByLevelExpressions(analysis, havingExpression, groupByLevelExpressions, groupByLevelController.getGroupedExpressionToRawExpressionsMap());
        }
        outputExpressions.clear();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        for (Expression groupedExpression : groupedSelectExpressions) {
            if (paginationController.hasCurOffset()) {
                paginationController.consumeOffset();
                continue;
            }
            if (!paginationController.hasCurLimit()) break;
            Pair<Expression, String> outputExpression = this.removeAliasFromExpression(groupedExpression, groupByLevelController.getAlias(groupedExpression.getExpressionString()));
            Expression groupedExpressionWithoutAlias = (Expression)outputExpression.left;
            this.analyzeExpression(analysis, groupedExpressionWithoutAlias);
            outputExpressions.add(outputExpression);
            this.updateGroupByLevelExpressions(analysis, groupedExpression, groupByLevelExpressions, groupByLevelController.getGroupedExpressionToRawExpressionsMap());
            paginationController.consumeLimit();
        }
        this.checkDataTypeConsistencyInGroupByLevel(analysis, groupByLevelExpressions);
        analysis.setCrossGroupByExpressions(groupByLevelExpressions);
    }

    private void checkDataTypeConsistencyInGroupByLevel(Analysis analysis, Map<Expression, Set<Expression>> groupByLevelExpressions) {
        for (Expression groupedAggregationExpression : groupByLevelExpressions.keySet()) {
            TSDataType checkedDataType = analysis.getType(groupedAggregationExpression);
            for (Expression rawAggregationExpression : groupByLevelExpressions.get(groupedAggregationExpression)) {
                if (analysis.getType(rawAggregationExpression) == checkedDataType) continue;
                throw new SemanticException(String.format("GROUP BY LEVEL: the data types of the same output column[%s] should be the same.", groupedAggregationExpression));
            }
        }
    }

    private void updateGroupByLevelExpressions(Analysis analysis, Expression expression, Map<Expression, Set<Expression>> groupByLevelExpressions, Map<Expression, Set<Expression>> groupedExpressionToRawExpressionsMap) {
        for (Expression groupedAggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
            Set<Expression> groupedExpressionSet = groupedExpressionToRawExpressionsMap.get(groupedAggregationExpression).stream().map(ExpressionAnalyzer::removeAliasFromExpression).collect(Collectors.toSet());
            Expression groupedAggregationExpressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(groupedAggregationExpression);
            this.analyzeExpression(analysis, groupedAggregationExpressionWithoutAlias);
            groupedExpressionSet.forEach(groupedExpression -> this.analyzeExpression(analysis, (Expression)groupedExpression));
            groupByLevelExpressions.computeIfAbsent(groupedAggregationExpressionWithoutAlias, key -> new HashSet()).addAll(groupedExpressionSet);
        }
    }

    private Pair<Expression, String> removeAliasFromExpression(Expression rawExpression, String rawAlias) {
        Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(rawExpression);
        String alias = !Objects.equals(expressionWithoutAlias, rawExpression) ? rawExpression.getExpressionString() : null;
        alias = rawAlias == null ? alias : rawAlias;
        return new Pair((Object)expressionWithoutAlias, (Object)alias);
    }

    private void analyzeGroupByTag(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isGroupByTag()) {
            return;
        }
        if (analysis.hasValueFilter()) {
            throw new SemanticException("Only time filters are supported in GROUP BY TAGS query");
        }
        List<String> tagKeys = queryStatement.getGroupByTagComponent().getTagKeys();
        HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands = new HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>>();
        LinkedHashMap<Expression, Set<Expression>> outputExpressionToRawExpressionsMap = new LinkedHashMap<Expression, Set<Expression>>();
        for (Pair<Expression, String> outputExpressionAndAlias : outputExpressions) {
            FunctionExpression rawExpression = (FunctionExpression)outputExpressionAndAlias.getLeft();
            FunctionExpression measurementExpression = (FunctionExpression)ExpressionAnalyzer.getMeasurementExpression(rawExpression);
            outputExpressionToRawExpressionsMap.computeIfAbsent(measurementExpression, v -> new HashSet()).add(rawExpression);
            Map tagMap = ((MeasurementPath)((TimeSeriesOperand)measurementExpression.getExpressions().get(0)).getPath()).getTagMap();
            ArrayList<String> tagValues = new ArrayList<String>();
            for (String tagKey : tagKeys) {
                tagValues.add((String)tagMap.get(tagKey));
            }
            tagValuesToGroupedTimeseriesOperands.computeIfAbsent(tagValues, key -> new LinkedHashMap()).computeIfAbsent(measurementExpression, key -> new ArrayList()).add(rawExpression.getExpressions().get(0));
        }
        outputExpressions.clear();
        for (String tagKey : tagKeys) {
            TimeSeriesOperand tagKeyExpression = TimeSeriesOperand.constructColumnHeaderExpression(tagKey, TSDataType.TEXT);
            this.analyzeExpression(analysis, tagKeyExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)tagKeyExpression, null));
        }
        for (Expression outputExpression : outputExpressionToRawExpressionsMap.keySet()) {
            this.analyzeExpression(analysis, outputExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)outputExpression, null));
        }
        analysis.setTagKeys(queryStatement.getGroupByTagComponent().getTagKeys());
        analysis.setTagValuesToGroupedTimeseriesOperands(tagValuesToGroupedTimeseriesOperands);
        analysis.setCrossGroupByExpressions(outputExpressionToRawExpressionsMap);
    }

    private void analyzeDeviceToAggregation(Analysis analysis, QueryStatement queryStatement, Map<String, Set<Expression>> deviceToAggregationExpressions) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        Map<String, Set<Expression>> deviceToSelectExpressions = analysis.getDeviceToSelectExpressions();
        for (String deviceName : deviceToSelectExpressions.keySet()) {
            Set<Expression> selectExpressions = deviceToSelectExpressions.get(deviceName);
            LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
            for (Expression expression : selectExpressions) {
                aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression));
            }
            deviceToAggregationExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(aggregationExpressions);
        }
    }

    private void analyzeAggregation(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        if (queryStatement.isGroupByLevel() || queryStatement.isGroupByTag()) {
            Set<Expression> aggregationExpressions = analysis.getCrossGroupByExpressions().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            analysis.setAggregationExpressions(aggregationExpressions);
        } else {
            HashSet<Expression> aggregationExpressions = new HashSet<Expression>();
            for (Expression expression : analysis.getSelectExpressions()) {
                aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression));
            }
            if (queryStatement.hasHaving()) {
                aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
            }
            analysis.setAggregationExpressions(aggregationExpressions);
        }
    }

    private void analyzeDeviceToSourceTransform(Analysis analysis, QueryStatement queryStatement) {
        HashMap<String, Set<Expression>> deviceToSourceTransformExpressions = new HashMap();
        if (queryStatement.isAggregationQuery()) {
            Map<String, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
            for (String deviceName : deviceToAggregationExpressions.keySet()) {
                Set<Expression> aggregationExpressions = deviceToAggregationExpressions.get(deviceName);
                LinkedHashSet<Expression> sourceTransformExpressions = new LinkedHashSet<Expression>();
                for (Expression expression : aggregationExpressions) {
                    sourceTransformExpressions.add(expression.getExpressions().get(0));
                }
                if (queryStatement.hasGroupByExpression()) {
                    sourceTransformExpressions.add(analysis.getDeviceToGroupByExpression().get(deviceName));
                }
                deviceToSourceTransformExpressions.put(deviceName, sourceTransformExpressions);
            }
        } else {
            deviceToSourceTransformExpressions = analysis.getDeviceToSelectExpressions();
        }
        analysis.setDeviceToSourceTransformExpressions(deviceToSourceTransformExpressions);
    }

    private void analyzeSourceTransform(Analysis analysis, QueryStatement queryStatement) {
        HashSet<Expression> sourceTransformExpressions = new HashSet();
        if (queryStatement.isAggregationQuery()) {
            for (Expression expression : analysis.getAggregationExpressions()) {
                sourceTransformExpressions.add(expression.getExpressions().get(0));
            }
        } else {
            sourceTransformExpressions = analysis.getSelectExpressions();
        }
        if (queryStatement.hasGroupByExpression()) {
            sourceTransformExpressions.add(analysis.getGroupByExpression());
        }
        analysis.setSourceTransformExpressions(sourceTransformExpressions);
    }

    private void analyzeDeviceToSource(Analysis analysis, QueryStatement queryStatement) {
        HashMap<String, Set<Expression>> deviceToSourceExpressions = new HashMap<String, Set<Expression>>();
        Map<String, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
        for (String deviceName : deviceToSourceTransformExpressions.keySet()) {
            Set<Expression> sourceTransformExpressions = deviceToSourceTransformExpressions.get(deviceName);
            LinkedHashSet<Expression> sourceExpressions = new LinkedHashSet<Expression>();
            for (Expression expression : sourceTransformExpressions) {
                sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression));
            }
            deviceToSourceExpressions.put(deviceName, sourceExpressions);
        }
        if (queryStatement.hasWhere()) {
            Map<String, Expression> deviceToWhereExpression = analysis.getDeviceToWhereExpression();
            for (String deviceName : deviceToWhereExpression.keySet()) {
                Expression whereExpression = deviceToWhereExpression.get(deviceName);
                deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(ExpressionAnalyzer.searchSourceExpressions(whereExpression));
            }
        }
        analysis.setDeviceToSourceExpressions(deviceToSourceExpressions);
    }

    private void analyzeSource(Analysis analysis, QueryStatement queryStatement) {
        HashSet<Expression> sourceExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.getSourceTransformExpressions()) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression));
        }
        if (queryStatement.hasWhere()) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(analysis.getWhereExpression()));
        }
        analysis.setSourceExpressions(sourceExpressions);
    }

    private void analyzeDeviceToWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, Set<PartialPath> deviceSet) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        HashMap<String, Expression> deviceToWhereExpression = new HashMap<String, Expression>();
        Iterator<PartialPath> deviceIterator = deviceSet.iterator();
        while (deviceIterator.hasNext()) {
            Expression whereExpression;
            PartialPath devicePath = deviceIterator.next();
            try {
                whereExpression = this.analyzeWhereSplitByDevice(queryStatement, devicePath, schemaTree);
            }
            catch (SemanticException e) {
                if (e instanceof MeasurementNotExistException) {
                    logger.warn(e.getMessage());
                    deviceIterator.remove();
                    analysis.getDeviceToSelectExpressions().remove(devicePath.getFullPath());
                    if (!queryStatement.isAggregationQuery()) continue;
                    analysis.getDeviceToAggregationExpressions().remove(devicePath.getFullPath());
                    continue;
                }
                throw e;
            }
            TSDataType outputType = this.analyzeExpression(analysis, whereExpression);
            if (outputType != TSDataType.BOOLEAN) {
                throw new SemanticException(String.format("The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.", outputType));
            }
            deviceToWhereExpression.put(devicePath.getFullPath(), whereExpression);
        }
        analysis.setDeviceToWhereExpression(deviceToWhereExpression);
    }

    private void analyzeWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        List<Expression> conJunctions = ExpressionAnalyzer.removeWildcardInFilter(queryStatement.getWhereCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true);
        Expression whereExpression = ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
        TSDataType outputType = this.analyzeExpression(analysis, whereExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    private Expression analyzeWhereSplitByDevice(QueryStatement queryStatement, PartialPath devicePath, ISchemaTree schemaTree) {
        List<Expression> conJunctions = ExpressionAnalyzer.removeWildcardInFilterByDevice(queryStatement.getWhereCondition().getPredicate(), devicePath, schemaTree, true);
        return ExpressionUtils.constructQueryFilter(conJunctions.stream().distinct().collect(Collectors.toList()));
    }

    private void analyzeDeviceView(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
        selectExpressions.add(deviceExpression);
        if (queryStatement.isOutputEndTime()) {
            selectExpressions.add(endTimeExpression);
        }
        selectExpressions.addAll(outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(LinkedHashSet::new)));
        analysis.setSelectExpressions(selectExpressions);
        LinkedHashSet<Expression> deviceViewOutputExpressions = new LinkedHashSet<Expression>();
        if (queryStatement.isAggregationQuery()) {
            deviceViewOutputExpressions.add(deviceExpression);
            if (queryStatement.isOutputEndTime()) {
                deviceViewOutputExpressions.add(endTimeExpression);
            }
            for (Expression selectExpression : selectExpressions) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(selectExpression));
            }
            if (queryStatement.hasHaving()) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
            }
        } else {
            deviceViewOutputExpressions = selectExpressions;
        }
        analysis.setDeviceViewOutputExpressions(deviceViewOutputExpressions);
        List deviceViewOutputColumns = deviceViewOutputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
        LinkedHashMap deviceToOutputColumnsMap = new LinkedHashMap();
        Map<String, Set<Expression>> deviceToOutputExpressions = queryStatement.isAggregationQuery() ? analysis.getDeviceToAggregationExpressions() : analysis.getDeviceToSourceTransformExpressions();
        for (String deviceName : deviceToOutputExpressions.keySet()) {
            Set<Expression> outputExpressionsUnderDevice = deviceToOutputExpressions.get(deviceName);
            LinkedHashSet<String> outputColumns = new LinkedHashSet<String>();
            if (queryStatement.isOutputEndTime()) {
                outputColumns.add("__endTime");
            }
            for (Expression expression : outputExpressionsUnderDevice) {
                outputColumns.add(ExpressionAnalyzer.getMeasurementExpression(expression).toString());
            }
            deviceToOutputColumnsMap.put(deviceName, outputColumns);
        }
        HashMap<String, List<Integer>> deviceViewInputIndexesMap = new HashMap<String, List<Integer>>();
        for (String deviceName : deviceToOutputColumnsMap.keySet()) {
            ArrayList outputsUnderDevice = new ArrayList((Collection)deviceToOutputColumnsMap.get(deviceName));
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (String output : outputsUnderDevice) {
                int index = deviceViewOutputColumns.indexOf(output);
                Preconditions.checkState((index >= 1 ? 1 : 0) != 0, (String)"output column '%s' is not stored in %s", (Object)output, deviceViewOutputColumns);
                indexes.add(index);
            }
            deviceViewInputIndexesMap.put(deviceName, indexes);
        }
        analysis.setDeviceViewInputIndexesMap(deviceViewInputIndexesMap);
        analysis.setDeviceViewSpecialProcess(this.analyzeDeviceViewSpecialProcess(deviceViewOutputExpressions, queryStatement, analysis));
    }

    private boolean analyzeDeviceViewSpecialProcess(Set<Expression> deviceViewOutputExpressions, QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isAggregationQuery() || queryStatement.hasWhere() && ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(queryStatement.getWhereCondition().getPredicate(), analysis)) {
            return true;
        }
        for (Expression expression : deviceViewOutputExpressions) {
            if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(expression, analysis)) continue;
            return true;
        }
        return false;
    }

    private void analyzeOutput(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
            return;
        }
        boolean isIgnoreTimestamp = queryStatement.isAggregationQuery() && !queryStatement.isGroupBy();
        ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
        if (queryStatement.isAlignByDevice()) {
            columnHeaders.add(new ColumnHeader("Device", TSDataType.TEXT, null));
        }
        if (queryStatement.isOutputEndTime()) {
            columnHeaders.add(new ColumnHeader("__endTime", TSDataType.INT64, null));
        }
        for (Pair<Expression, String> expressionAliasPair : outputExpressions) {
            columnHeaders.add(new ColumnHeader(((Expression)expressionAliasPair.left).getExpressionString(), analysis.getType((Expression)expressionAliasPair.left), (String)expressionAliasPair.right));
        }
        analysis.setRespDatasetHeader(new DatasetHeader(columnHeaders, isIgnoreTimestamp));
    }

    private void analyzeOrderBy(Analysis analysis, QueryStatement queryStatement) {
        analysis.setMergeOrderParameter(new OrderByParameter(queryStatement.getSortItemList()));
    }

    private TSDataType analyzeExpression(Analysis analysis, Expression expression) {
        ExpressionTypeAnalyzer.analyzeExpression(analysis, expression);
        return analysis.getType(expression);
    }

    private void analyzeDeviceToGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, Set<PartialPath> deviceSet) {
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        LinkedHashMap<String, Expression> deviceToGroupByExpression = new LinkedHashMap<String, Expression>();
        if (queryStatement.hasGroupByExpression()) {
            Expression expression = groupByComponent.getControlColumnExpression();
            for (PartialPath device : deviceSet) {
                List<Expression> groupByExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(expression, device, schemaTree);
                if (groupByExpressionsOfOneDevice.size() != 1) {
                    throw new SemanticException("Expression in group by should indicate one value");
                }
                Expression groupByExpressionOfOneDevice = groupByExpressionsOfOneDevice.get(0);
                List<Expression> aggregationExpression = ExpressionAnalyzer.searchAggregationExpressions(groupByExpressionOfOneDevice);
                if (aggregationExpression != null && aggregationExpression.size() != 0) {
                    throw new SemanticException("Aggregation expression shouldn't exist in group by clause");
                }
                deviceToGroupByExpression.put(device.getFullPath(), groupByExpressionOfOneDevice);
            }
        }
        if (windowType == WindowType.VARIATION_WINDOW) {
            double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
            for (Expression expression : deviceToGroupByExpression.values()) {
                this.checkGroupByVariationExpressionType(analysis, expression, delta);
            }
            GroupByVariationParameter groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
            analysis.setGroupByParameter(groupByParameter);
            analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
        } else if (windowType == WindowType.CONDITION_WINDOW) {
            Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
            for (Expression expression : deviceToGroupByExpression.values()) {
                this.checkGroupByConditionExpressionType(analysis, expression, keepExpression);
            }
            GroupByConditionParameter groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
            analysis.setGroupByParameter(groupByParameter);
            analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
        } else if (windowType == WindowType.SESSION_WINDOW) {
            GroupBySessionParameter groupByParameter = new GroupBySessionParameter(((GroupBySessionComponent)groupByComponent).getTimeInterval());
            analysis.setGroupByParameter(groupByParameter);
        } else {
            throw new SemanticException("Unsupported window type");
        }
    }

    private void analyzeGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        Expression groupByExpression = null;
        if (queryStatement.hasGroupByExpression()) {
            groupByExpression = groupByComponent.getControlColumnExpression();
            List<Expression> expressions = ExpressionAnalyzer.removeWildcardInExpression(groupByExpression, schemaTree);
            if (expressions.size() != 1) {
                throw new SemanticException("Expression in group by should indicate one value");
            }
            List<Expression> aggregationExpression = ExpressionAnalyzer.searchAggregationExpressions(expressions.get(0));
            if (aggregationExpression != null && aggregationExpression.size() != 0) {
                throw new SemanticException("Aggregation expression shouldn't exist in group by clause");
            }
            groupByExpression = expressions.get(0);
        }
        if (windowType == WindowType.VARIATION_WINDOW) {
            double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
            this.checkGroupByVariationExpressionType(analysis, groupByExpression, delta);
            GroupByVariationParameter groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.CONDITION_WINDOW) {
            Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
            this.checkGroupByConditionExpressionType(analysis, groupByExpression, keepExpression);
            GroupByConditionParameter groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.SESSION_WINDOW) {
            long interval = ((GroupBySessionComponent)groupByComponent).getTimeInterval();
            GroupBySessionParameter groupByParameter = new GroupBySessionParameter(interval);
            analysis.setGroupByParameter(groupByParameter);
        } else {
            throw new SemanticException("Unsupported window type");
        }
    }

    private void checkGroupByVariationExpressionType(Analysis analysis, Expression groupByExpression, double delta) {
        TSDataType type = this.analyzeExpression(analysis, groupByExpression);
        if (delta != 0.0 && !type.isNumeric()) {
            throw new SemanticException("Only support numeric type when delta != 0");
        }
    }

    private void checkGroupByConditionExpressionType(Analysis analysis, Expression groupByExpression, Expression keepExpression) {
        TSDataType type = this.analyzeExpression(analysis, groupByExpression);
        if (type != TSDataType.BOOLEAN) {
            throw new SemanticException("Only support boolean type in predict of group by series");
        }
        if (!(keepExpression instanceof ConstantOperand)) {
            if (keepExpression instanceof CompareBinaryExpression) {
                Expression leftExpression = ((CompareBinaryExpression)keepExpression).getLeftExpression();
                Expression rightExpression = ((CompareBinaryExpression)keepExpression).getRightExpression();
                if (!(leftExpression instanceof TimeSeriesOperand && leftExpression.getExpressionString().equalsIgnoreCase("keep") && rightExpression instanceof ConstantOperand)) {
                    throw new SemanticException(String.format("Please check the keep condition ([%s]),it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
                }
            } else {
                throw new SemanticException(String.format("Please check the keep condition ([%s]),it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
            }
        }
    }

    private void analyzeGroupByTime(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isGroupByTime()) {
            return;
        }
        GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
        if ((groupByTimeComponent.isIntervalByMonth() || groupByTimeComponent.isSlidingStepByMonth()) && queryStatement.getResultTimeOrder() == Ordering.DESC) {
            throw new SemanticException("Group by month doesn't support order by time desc now.");
        }
        if (!queryStatement.isCqQueryBody() && groupByTimeComponent.getStartTime() == 0L && groupByTimeComponent.getEndTime() == 0L) {
            throw new SemanticException("The query time range should be specified in the GROUP BY TIME clause.");
        }
        analysis.setGroupByTimeParameter(new GroupByTimeParameter(groupByTimeComponent));
    }

    private void analyzeFill(Analysis analysis, QueryStatement queryStatement) {
        if (queryStatement.getFillComponent() == null) {
            return;
        }
        FillComponent fillComponent = queryStatement.getFillComponent();
        analysis.setFillDescriptor(new FillDescriptor(fillComponent.getFillPolicy(), fillComponent.getFillValue()));
    }

    private void analyzeDataPartition(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree) {
        HashSet<String> deviceSet = new HashSet();
        if (queryStatement.isAlignByDevice()) {
            deviceSet = analysis.getDeviceToSourceExpressions().keySet();
        } else {
            for (Expression expression : analysis.getSourceExpressions()) {
                deviceSet.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression));
            }
        }
        DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree, analysis.getGlobalTimeFilter());
        analysis.setDataPartitionInfo(dataPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPartition fetchDataPartitionByDevices(Set<String> deviceSet, ISchemaTree schemaTree, Filter globalTimeFilter) {
        long startTime = System.nanoTime();
        try {
            DataPartition dataPartition;
            Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> res = AnalyzeVisitor.getTimePartitionSlotList(globalTimeFilter);
            if (((List)res.left).isEmpty() && !((Boolean)((Pair)res.right).left).booleanValue()) {
                DataPartition dataPartition2 = new DataPartition(Collections.emptyMap(), CONFIG.getSeriesPartitionExecutorClass(), CONFIG.getSeriesPartitionSlotNum());
                return dataPartition2;
            }
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (String devicePath : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam(devicePath, (List)res.left, ((Boolean)((Pair)res.right).left).booleanValue(), ((Boolean)((Pair)res.right).right).booleanValue());
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase(devicePath), key -> new ArrayList()).add(queryParam);
            }
            if (((Boolean)((Pair)res.right).left).booleanValue() || ((Boolean)((Pair)res.right).right).booleanValue()) {
                dataPartition = this.partitionFetcher.getDataPartitionWithUnclosedTimeRange(sgNameToQueryParamsMap);
                return dataPartition;
            }
            dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            return dataPartition;
        }
        finally {
            QueryMetricsManager.getInstance().recordPlanCost("partition_fetcher", System.nanoTime() - startTime);
        }
    }

    public static Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> getTimePartitionSlotList(Filter timeFilter) {
        boolean needRightAll;
        TTimePartitionSlot timePartitionSlot;
        long endTime;
        long startTime;
        boolean needLeftAll;
        if (timeFilter == null) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        List timeRangeList = timeFilter.getTimeRanges();
        if (timeRangeList.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)false, (Object)false));
        }
        if (timeRangeList.size() == 1 && ((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE && ((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMax() == Long.MAX_VALUE) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        int index = 0;
        int size = timeRangeList.size();
        if (((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE) {
            needLeftAll = true;
            startTime = ((TimeRange)timeRangeList.get(0)).getMax() / TimePartitionUtils.timePartitionInterval * TimePartitionUtils.timePartitionInterval;
            endTime = startTime + TimePartitionUtils.timePartitionInterval;
            timePartitionSlot = TimePartitionUtils.getTimePartition(((TimeRange)timeRangeList.get(0)).getMax());
        } else {
            startTime = ((TimeRange)timeRangeList.get(0)).getMin() / TimePartitionUtils.timePartitionInterval * TimePartitionUtils.timePartitionInterval;
            endTime = startTime + TimePartitionUtils.timePartitionInterval;
            timePartitionSlot = TimePartitionUtils.getTimePartition(((TimeRange)timeRangeList.get(0)).getMin());
            needLeftAll = false;
        }
        if (((TimeRange)timeRangeList.get(size - 1)).getMax() == Long.MAX_VALUE) {
            needRightAll = true;
            --size;
        } else {
            needRightAll = false;
        }
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        while (index < size) {
            long curLeft = ((TimeRange)timeRangeList.get(index)).getMin();
            long curRight = ((TimeRange)timeRangeList.get(index)).getMax();
            if (curLeft >= endTime) {
                result.add(timePartitionSlot);
                endTime = (curLeft / TimePartitionUtils.timePartitionInterval + 1L) * TimePartitionUtils.timePartitionInterval;
                timePartitionSlot = TimePartitionUtils.getTimePartition(curLeft);
                continue;
            }
            if (curRight >= endTime) {
                result.add(timePartitionSlot);
                timePartitionSlot = new TTimePartitionSlot(endTime);
                endTime += TimePartitionUtils.timePartitionInterval;
                continue;
            }
            ++index;
        }
        result.add(timePartitionSlot);
        if (needRightAll) {
            TTimePartitionSlot lastTimePartitionSlot = TimePartitionUtils.getTimePartition(((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMin());
            if (lastTimePartitionSlot.startTime != timePartitionSlot.startTime) {
                result.add(lastTimePartitionSlot);
            }
        }
        return new Pair(result, (Object)new Pair((Object)needLeftAll, (Object)needRightAll));
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, Set<PartialPath> deviceSet, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        ArrayList<PartialPath> sourceDevices = new ArrayList<PartialPath>(deviceSet);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceDevices, sourceColumns);
        DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor = new DeviceViewIntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoDeviceMeasurementIterator intoDeviceMeasurementIterator = intoComponent.getIntoDeviceMeasurementIterator();
        for (PartialPath sourceDevice : sourceDevices) {
            PartialPath deviceTemplate = intoDeviceMeasurementIterator.getDeviceTemplate();
            boolean isAlignedDevice = intoDeviceMeasurementIterator.isAlignedDevice();
            PartialPath targetDevice = SelectIntoUtils.constructTargetDevice(sourceDevice, deviceTemplate);
            deviceViewIntoPathDescriptor.specifyDeviceAlignment(targetDevice.toString(), isAlignedDevice);
            for (Expression sourceColumn : sourceColumns) {
                String measurementTemplate = intoDeviceMeasurementIterator.getMeasurementTemplate();
                String targetMeasurement = sourceColumn instanceof TimeSeriesOperand ? SelectIntoUtils.constructTargetMeasurement(sourceDevice.concatNode(sourceColumn.toString()), measurementTemplate) : measurementTemplate;
                deviceViewIntoPathDescriptor.specifyTargetDeviceMeasurement(sourceDevice, targetDevice, sourceColumn.toString(), targetMeasurement);
                targetPathTree.appendFullPath(targetDevice, targetMeasurement);
                deviceViewIntoPathDescriptor.recordSourceColumnDataType(sourceColumn.toString(), analysis.getType(sourceColumn));
                intoDeviceMeasurementIterator.nextMeasurement();
            }
            intoDeviceMeasurementIterator.nextDevice();
        }
        deviceViewIntoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree);
        QueryMetricsManager.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
        deviceViewIntoPathDescriptor.bindType(targetSchemaTree);
        analysis.setDeviceViewIntoPathDescriptor(deviceViewIntoPathDescriptor);
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceColumns);
        IntoPathDescriptor intoPathDescriptor = new IntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoPathIterator intoPathIterator = intoComponent.getIntoPathIterator();
        for (Expression sourceColumn : sourceColumns) {
            PartialPath targetPath;
            PartialPath deviceTemplate = intoPathIterator.getDeviceTemplate();
            String measurementTemplate = intoPathIterator.getMeasurementTemplate();
            boolean isAlignedDevice = intoPathIterator.isAlignedDevice();
            if (sourceColumn instanceof TimeSeriesOperand) {
                PartialPath sourcePath = ((TimeSeriesOperand)sourceColumn).getPath();
                targetPath = SelectIntoUtils.constructTargetPath(sourcePath, deviceTemplate, measurementTemplate);
            } else {
                targetPath = deviceTemplate.concatNode(measurementTemplate);
            }
            intoPathDescriptor.specifyTargetPath(sourceColumn.toString(), targetPath);
            intoPathDescriptor.specifyDeviceAlignment(targetPath.getDevicePath().toString(), isAlignedDevice);
            targetPathTree.appendFullPath(targetPath);
            intoPathDescriptor.recordSourceColumnDataType(sourceColumn.toString(), analysis.getType(sourceColumn));
            intoPathIterator.next();
        }
        intoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree);
        QueryMetricsManager.getInstance().recordPlanCost("schema_fetcher", System.nanoTime() - startTime);
        intoPathDescriptor.bindType(targetSchemaTree);
        analysis.setIntoPathDescriptor(intoPathDescriptor);
    }

    private void checkDataTypeConsistencyInAlignByDevice(Analysis analysis, List<Expression> expressions) {
        TSDataType checkedDataType = analysis.getType(expressions.get(0));
        for (Expression expression : expressions) {
            if (analysis.getType(expression) == checkedDataType) continue;
            throw new SemanticException("ALIGN BY DEVICE: the data types of the same measurement column should be the same across devices.");
        }
    }

    @Override
    public Analysis visitInsert(InsertStatement insertStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertStatement.semanticCheck();
        long[] timeArray = insertStatement.getTimes();
        PartialPath devicePath = insertStatement.getDevice();
        String[] measurementList = insertStatement.getMeasurementList();
        if (timeArray.length == 1) {
            InsertRowStatement insertRowStatement = new InsertRowStatement();
            insertRowStatement.setDevicePath(devicePath);
            insertRowStatement.setTime(timeArray[0]);
            insertRowStatement.setMeasurements(measurementList);
            insertRowStatement.setDataTypes(new TSDataType[measurementList.length]);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(0), 0, values, 0, values.length);
            insertRowStatement.setValues(values);
            insertRowStatement.setNeedInferType(true);
            insertRowStatement.setAligned(insertStatement.isAligned());
            return insertRowStatement.accept(this, context);
        }
        InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement = new InsertRowsOfOneDeviceStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (int i = 0; i < timeArray.length; ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(devicePath);
            String[] measurements = new String[measurementList.length];
            System.arraycopy(measurementList, 0, measurements, 0, measurements.length);
            statement.setMeasurements(measurements);
            statement.setTime(timeArray[i]);
            TSDataType[] dataTypes = new TSDataType[measurementList.length];
            statement.setDataTypes(dataTypes);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(i), 0, values, 0, values.length);
            statement.setValues(values);
            statement.setAligned(insertStatement.isAligned());
            statement.setNeedInferType(true);
            insertRowStatementList.add(statement);
        }
        insertRowsOfOneDeviceStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsOfOneDeviceStatement.accept(this, context);
    }

    @Override
    public Analysis visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createTimeSeriesStatement.getPath().getNodeLength() < 3) {
            throw new RuntimeException(new IllegalPathException(createTimeSeriesStatement.getPath().getFullPath()));
        }
        this.analyzeSchemaProps(createTimeSeriesStatement.getProps());
        if (createTimeSeriesStatement.getTags() != null && !createTimeSeriesStatement.getTags().isEmpty() && createTimeSeriesStatement.getAttributes() != null && !createTimeSeriesStatement.getAttributes().isEmpty()) {
            for (String tagKey : createTimeSeriesStatement.getTags().keySet()) {
                if (!createTimeSeriesStatement.getAttributes().containsKey(tagKey)) continue;
                throw new SemanticException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
            }
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTimeSeriesStatement);
        this.checkIsTemplateCompatible(createTimeSeriesStatement.getPath(), createTimeSeriesStatement.getAlias());
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(createTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    private void checkIsTemplateCompatible(PartialPath timeseriesPath, String alias) {
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetInfo(timeseriesPath);
        if (templateInfo != null) {
            if (((Template)templateInfo.left).hasSchema(timeseriesPath.getMeasurement())) {
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(timeseriesPath.getFullPath(), ((Template)templateInfo.left).getName(), timeseriesPath.getMeasurement())));
            }
            if (alias != null && ((Template)templateInfo.left).hasSchema(alias)) {
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(timeseriesPath.getDevicePath().concatNode(alias).getFullPath(), ((Template)templateInfo.left).getName(), alias)));
            }
        }
    }

    private void checkIsTemplateCompatible(PartialPath devicePath, List<String> measurements, List<String> aliasList) {
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetInfo(devicePath);
        if (templateInfo != null) {
            Template template = (Template)templateInfo.left;
            for (String measurement : measurements) {
                if (!template.hasSchema(measurement)) continue;
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(devicePath.concatNode(measurement).getFullPath(), ((Template)templateInfo.left).getName(), measurement)));
            }
            if (aliasList == null) {
                return;
            }
            for (String alias : aliasList) {
                if (!template.hasSchema(alias)) continue;
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(devicePath.concatNode(alias).getFullPath(), ((Template)templateInfo.left).getName(), alias)));
            }
        }
    }

    private void analyzeSchemaProps(Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        HashMap<String, String> caseChangeMap = new HashMap<String, String>();
        for (String key : props.keySet()) {
            caseChangeMap.put(key.toLowerCase(Locale.ROOT), key);
        }
        for (String lowerCaseKey : caseChangeMap.keySet()) {
            if (!IoTDBConstant.ALLOWED_SCHEMA_PROPS.contains(lowerCaseKey)) {
                throw new SemanticException(new MetadataException(String.format("%s is not a legal prop.", caseChangeMap.get(lowerCaseKey))));
            }
            props.put(lowerCaseKey, props.remove(caseChangeMap.get(lowerCaseKey)));
        }
        if (props.containsKey("deadband")) {
            props.put("loss", props.remove("deadband"));
        }
    }

    private void analyzeSchemaProps(List<Map<String, String>> propsList) {
        if (propsList == null) {
            return;
        }
        for (Map<String, String> props : propsList) {
            this.analyzeSchemaProps(props);
        }
    }

    @Override
    public Analysis visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createAlignedTimeSeriesStatement.getDevicePath().getNodeLength() < 2) {
            throw new RuntimeException(new IllegalPathException(createAlignedTimeSeriesStatement.getDevicePath().getFullPath()));
        }
        List<String> measurements = createAlignedTimeSeriesStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createAlignedTimeSeriesStatement);
        this.checkIsTemplateCompatible(createAlignedTimeSeriesStatement.getDevicePath(), createAlignedTimeSeriesStatement.getMeasurements(), createAlignedTimeSeriesStatement.getAliasList());
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : createAlignedTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(createAlignedTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalCreateTimeSeriesStatement);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : internalCreateTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(internalCreateTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalCreateMultiTimeSeriesStatement);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (PartialPath devicePath : internalCreateMultiTimeSeriesStatement.getDeviceMap().keySet()) {
            pathPatternTree.appendFullPath(devicePath.concatNode("*"));
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(createMultiTimeSeriesStatement);
        this.analyzeSchemaProps(createMultiTimeSeriesStatement.getPropsList());
        List<PartialPath> timeseriesPathList = createMultiTimeSeriesStatement.getPaths();
        List<String> aliasList = createMultiTimeSeriesStatement.getAliasList();
        for (int i = 0; i < timeseriesPathList.size(); ++i) {
            this.checkIsTemplateCompatible(timeseriesPathList.get(i), aliasList == null ? null : aliasList.get(i));
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath path : createMultiTimeSeriesStatement.getPaths()) {
            patternTree.appendFullPath(path);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(alterTimeSeriesStatement);
        if (alterTimeSeriesStatement.getAlias() != null) {
            this.checkIsTemplateCompatible(alterTimeSeriesStatement.getPath(), alterTimeSeriesStatement.getAlias());
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(alterTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertTabletStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertTabletStatement.getTimePartitionSlots());
        return this.getAnalysisForWriting(insertTabletStatement, Collections.singletonList(dataPartitionQueryParam));
    }

    @Override
    public Analysis visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertRowStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertRowStatement.getTimePartitionSlots());
        return this.getAnalysisForWriting(insertRowStatement, Collections.singletonList(dataPartitionQueryParam));
    }

    @Override
    public Analysis visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        HashMap<String, Set> dataPartitionQueryParamMap = new HashMap<String, Set>();
        for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
            Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertRowStatement.getDevicePath().getFullPath(), k -> new HashSet());
            timePartitionSlotSet.addAll(insertRowStatement.getTimePartitionSlots());
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (Map.Entry entry : dataPartitionQueryParamMap.entrySet()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath((String)entry.getKey());
            dataPartitionQueryParam.setTimePartitionSlotList(new ArrayList((Collection)entry.getValue()));
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        return this.getAnalysisForWriting(insertRowsStatement, dataPartitionQueryParams);
    }

    @Override
    public Analysis visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        HashMap<String, Set> dataPartitionQueryParamMap = new HashMap<String, Set>();
        for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
            Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertTabletStatement.getDevicePath().getFullPath(), k -> new HashSet());
            timePartitionSlotSet.addAll(insertTabletStatement.getTimePartitionSlots());
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (Map.Entry entry : dataPartitionQueryParamMap.entrySet()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath((String)entry.getKey());
            dataPartitionQueryParam.setTimePartitionSlotList(new ArrayList((Collection)entry.getValue()));
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        return this.getAnalysisForWriting(insertMultiTabletsStatement, dataPartitionQueryParams);
    }

    @Override
    public Analysis visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertRowsOfOneDeviceStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertRowsOfOneDeviceStatement.getTimePartitionSlots());
        return this.getAnalysisForWriting(insertRowsOfOneDeviceStatement, Collections.singletonList(dataPartitionQueryParam));
    }

    @Override
    public Analysis visitLoadFile(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        HashMap<String, Map<MeasurementSchema, File>> device2Schemas = new HashMap<String, Map<MeasurementSchema, File>>();
        HashMap<String, Pair<Boolean, File>> device2IsAligned = new HashMap<String, Pair<Boolean, File>>();
        for (File tsFile : loadTsFileStatement.getTsFiles()) {
            if (tsFile.length() == 0L) {
                logger.warn(String.format("TsFile %s is empty.", tsFile.getPath()));
                throw new SemanticException(String.format("TsFile %s is empty, please check it be flushed to disk correctly.", tsFile.getPath()));
            }
            try {
                TsFileResource resource = this.analyzeTsFile(loadTsFileStatement, tsFile, device2Schemas, device2IsAligned);
                loadTsFileStatement.addTsFileResource(resource);
            }
            catch (IllegalArgumentException e) {
                logger.warn(String.format("Parse file %s to resource error, this TsFile maybe empty.", tsFile.getPath()), (Throwable)e);
                throw new SemanticException(String.format("TsFile %s is empty or incomplete.", tsFile.getPath()));
            }
            catch (Exception e) {
                logger.warn(String.format("Parse file %s to resource error.", tsFile.getPath()), (Throwable)e);
                throw new SemanticException(String.format("Parse file %s to resource error", tsFile.getPath()));
            }
            if (device2Schemas.size() <= CONFIG.getMaxLoadingDeviceNumber()) continue;
            this.autoCreateAndVerifySchema(loadTsFileStatement, device2Schemas, device2IsAligned);
        }
        this.autoCreateAndVerifySchema(loadTsFileStatement, device2Schemas, device2IsAligned);
        Analysis analysis = new Analysis();
        analysis.setStatement(loadTsFileStatement);
        return analysis;
    }

    private void autoCreateAndVerifySchema(LoadTsFileStatement loadTsFileStatement, Map<String, Map<MeasurementSchema, File>> device2Schemas, Map<String, Pair<Boolean, File>> device2IsAligned) throws SemanticException {
        if (device2Schemas.isEmpty()) {
            return;
        }
        try {
            if (loadTsFileStatement.isVerifySchema()) {
                this.verifyLoadingMeasurements(device2Schemas);
            }
            if (loadTsFileStatement.isAutoCreateDatabase()) {
                this.autoCreateSg(loadTsFileStatement.getSgLevel(), device2Schemas);
            }
            ISchemaTree schemaTree = this.autoCreateSchema(device2Schemas, device2IsAligned);
            if (loadTsFileStatement.isVerifySchema()) {
                this.verifySchema(schemaTree, device2Schemas, device2IsAligned);
            }
        }
        catch (Exception e) {
            logger.warn("Auto create or verify schema error.", (Throwable)e);
            throw new SemanticException(String.format("Auto create or verify schema error when executing statement %s.", loadTsFileStatement));
        }
        finally {
            device2Schemas.clear();
            device2IsAligned.clear();
        }
    }

    private Analysis getAnalysisForWriting(Statement statement, List<DataPartitionQueryParam> dataPartitionQueryParams) {
        Analysis analysis = new Analysis();
        analysis.setStatement(statement);
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams);
        if (dataPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailMessage("Database not exists and failed to create automatically because enable_auto_create_schema is FALSE.");
        }
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    private TsFileResource analyzeTsFile(LoadTsFileStatement statement, File tsFile, Map<String, Map<MeasurementSchema, File>> device2Schemas, Map<String, Pair<Boolean, File>> device2IsAligned) throws IOException, VerifyMetadataException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            TsFileResource resource;
            Map device2Metadata = reader.getAllTimeseriesMetadata(true);
            if (IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled() || statement.isVerifySchema()) {
                for (Map.Entry entry : device2Metadata.entrySet()) {
                    String device = (String)entry.getKey();
                    List timeseriesMetadataList = (List)entry.getValue();
                    boolean isAligned = false;
                    for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                        TSDataType dataType = timeseriesMetadata.getTSDataType();
                        if (!dataType.equals((Object)TSDataType.VECTOR)) {
                            Pair pair = reader.readTimeseriesCompressionTypeAndEncoding(timeseriesMetadata);
                            MeasurementSchema measurementSchema = new MeasurementSchema(timeseriesMetadata.getMeasurementId(), dataType, (TSEncoding)pair.getRight(), (CompressionType)pair.getLeft());
                            device2Schemas.computeIfAbsent(device, o -> new HashMap()).put(measurementSchema, tsFile);
                            continue;
                        }
                        isAligned = true;
                    }
                    boolean finalIsAligned = isAligned;
                    if (((Boolean)device2IsAligned.computeIfAbsent((String)device, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$analyzeTsFile$16(boolean java.io.File java.lang.String ), (Ljava/lang/String;)Lorg/apache/iotdb/tsfile/utils/Pair;)((boolean)finalIsAligned, (File)tsFile)).left).equals(isAligned)) continue;
                    throw new VerifyMetadataException(String.format("Device %s has different aligned definition in tsFile %s and other TsFile.", device, tsFile.getParentFile()));
                }
            }
            if (!(resource = new TsFileResource(tsFile)).resourceFileExists()) {
                FileLoaderUtils.updateTsFileResource(device2Metadata, resource);
                resource.updatePlanIndexes(reader.getMinPlanIndex());
                resource.updatePlanIndexes(reader.getMaxPlanIndex());
            } else {
                resource.deserialize();
            }
            resource.setStatus(TsFileResourceStatus.CLOSED);
            TsFileResource tsFileResource = resource;
            return tsFileResource;
        }
    }

    private void autoCreateSg(int sgLevel, Map<String, Map<MeasurementSchema, File>> device2Schemas) throws VerifyMetadataException, LoadFileException, IllegalPathException {
        ++sgLevel;
        HashSet<PartialPath> sgSet = new HashSet<PartialPath>();
        for (String device : device2Schemas.keySet()) {
            PartialPath devicePath = new PartialPath(device);
            String[] nodes = devicePath.getNodes();
            String[] sgNodes = new String[sgLevel];
            if (nodes.length < sgLevel) {
                throw new VerifyMetadataException(String.format("Sg level %d is longer than device %s.", sgLevel, device));
            }
            System.arraycopy(nodes, 0, sgNodes, 0, sgLevel);
            PartialPath sgPath = new PartialPath(sgNodes);
            sgSet.add(sgPath);
        }
        for (PartialPath sgPath : sgSet) {
            DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
            statement.setStorageGroupPath(sgPath);
            this.executeSetStorageGroupStatement(statement);
        }
    }

    private void executeSetStorageGroupStatement(Statement statement) throws LoadFileException {
        long queryId = SessionManager.getInstance().requestQueryId();
        ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", this.partitionFetcher, this.schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
            logger.warn("Create Database error, statement: {}, result status is: {}", (Object)statement, (Object)result.status);
            throw new LoadFileException(String.format("Can not execute create database statement: %s", statement));
        }
    }

    private ISchemaTree autoCreateSchema(Map<String, Map<MeasurementSchema, File>> device2Schemas, Map<String, Pair<Boolean, File>> device2IsAligned) throws IllegalPathException {
        ArrayList<PartialPath> deviceList = new ArrayList<PartialPath>();
        ArrayList<String[]> measurementList = new ArrayList<String[]>();
        ArrayList<TSDataType[]> dataTypeList = new ArrayList<TSDataType[]>();
        ArrayList<TSEncoding[]> encodingsList = new ArrayList<TSEncoding[]>();
        ArrayList<CompressionType[]> compressionTypesList = new ArrayList<CompressionType[]>();
        ArrayList<Boolean> isAlignedList = new ArrayList<Boolean>();
        for (Map.Entry<String, Map<MeasurementSchema, File>> entry : device2Schemas.entrySet()) {
            int measurementSize = entry.getValue().size();
            String[] measurements = new String[measurementSize];
            TSDataType[] tsDataTypes = new TSDataType[measurementSize];
            TSEncoding[] encodings = new TSEncoding[measurementSize];
            CompressionType[] compressionTypes = new CompressionType[measurementSize];
            int index = 0;
            for (MeasurementSchema measurementSchema : entry.getValue().keySet()) {
                measurements[index] = measurementSchema.getMeasurementId();
                tsDataTypes[index] = measurementSchema.getType();
                encodings[index] = measurementSchema.getEncodingType();
                compressionTypes[index++] = measurementSchema.getCompressor();
            }
            deviceList.add(new PartialPath(entry.getKey()));
            measurementList.add(measurements);
            dataTypeList.add(tsDataTypes);
            encodingsList.add(encodings);
            compressionTypesList.add(compressionTypes);
            isAlignedList.add((Boolean)device2IsAligned.get((Object)entry.getKey()).left);
        }
        return SchemaValidator.validate(deviceList, measurementList, dataTypeList, encodingsList, compressionTypesList, isAlignedList);
    }

    private void verifyLoadingMeasurements(Map<String, Map<MeasurementSchema, File>> device2Schemas) throws VerifyMetadataException {
        for (Map.Entry<String, Map<MeasurementSchema, File>> deviceEntry : device2Schemas.entrySet()) {
            HashMap<String, MeasurementSchema> id2Schema = new HashMap<String, MeasurementSchema>();
            Map<MeasurementSchema, File> schema2TsFile = deviceEntry.getValue();
            for (Map.Entry<MeasurementSchema, File> entry : schema2TsFile.entrySet()) {
                String measurementId = entry.getKey().getMeasurementId();
                if (!id2Schema.containsKey(measurementId)) {
                    id2Schema.put(measurementId, entry.getKey());
                    continue;
                }
                MeasurementSchema conflictSchema = (MeasurementSchema)id2Schema.get(measurementId);
                String msg = String.format("Measurement %s Conflict, TsFile %s has measurement: %s, TsFile %s has measurement %s.", deviceEntry.getKey() + measurementId, entry.getValue().getPath(), entry.getKey(), schema2TsFile.get(conflictSchema).getPath(), conflictSchema);
                logger.warn(msg);
                throw new VerifyMetadataException(msg);
            }
        }
    }

    private void verifySchema(ISchemaTree schemaTree, Map<String, Map<MeasurementSchema, File>> device2Schemas, Map<String, Pair<Boolean, File>> device2IsAligned) throws VerifyMetadataException, IllegalPathException {
        for (Map.Entry<String, Map<MeasurementSchema, File>> entry : device2Schemas.entrySet()) {
            MeasurementSchema[] tsFileSchemas;
            String device = entry.getKey();
            DeviceSchemaInfo schemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath(device), Arrays.stream(tsFileSchemas = entry.getValue().keySet().toArray(new MeasurementSchema[0])).map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
            if (schemaInfo.isAligned() != ((Boolean)device2IsAligned.get((Object)device).left).booleanValue()) {
                throw new VerifyMetadataException(device, "Is aligned", ((Boolean)device2IsAligned.get((Object)device).left).toString(), ((File)device2IsAligned.get((Object)device).right).getPath(), String.valueOf(schemaInfo.isAligned()));
            }
            List<MeasurementSchema> originSchemaList = schemaInfo.getMeasurementSchemaList();
            int measurementSize = originSchemaList.size();
            for (int j = 0; j < measurementSize; ++j) {
                MeasurementSchema originSchema = originSchemaList.get(j);
                MeasurementSchema tsFileSchema = tsFileSchemas[j];
                String measurementPath = device + "." + originSchema.getMeasurementId();
                if (!tsFileSchema.getType().equals((Object)originSchema.getType())) {
                    throw new VerifyMetadataException(measurementPath, "Datatype", tsFileSchema.getType().name(), entry.getValue().get(tsFileSchema).getPath(), originSchema.getType().name());
                }
                if (!tsFileSchema.getEncodingType().equals((Object)originSchema.getEncodingType())) {
                    throw new VerifyMetadataException(measurementPath, "Encoding", tsFileSchema.getEncodingType().name(), entry.getValue().get(tsFileSchema).getPath(), originSchema.getEncodingType().name());
                }
                if (tsFileSchema.getCompressor().equals((Object)originSchema.getCompressor())) continue;
                throw new VerifyMetadataException(measurementPath, "Compress type", tsFileSchema.getCompressor().name(), entry.getValue().get(tsFileSchema).getPath(), originSchema.getCompressor().name());
            }
        }
    }

    @Override
    public Analysis visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(showTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        if (showTimeSeriesStatement.isOrderByHeat()) {
            patternTree.constructTree();
            logger.debug("[StartFetchSchema]");
            ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree);
            logger.debug("[EndFetchSchema]]");
            this.analyzeLastSource(analysis, Collections.singletonList(new TimeSeriesOperand(showTimeSeriesStatement.getPathPattern())), schemaTree);
            this.analyzeDataPartition(analysis, new QueryStatement(), schemaTree);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowStorageGroup(ShowStorageGroupStatement showStorageGroupStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showStorageGroupStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowStorageGroupHeader(showStorageGroupStatement.isDetailed()));
        return analysis;
    }

    @Override
    public Analysis visitShowTTL(ShowTTLStatement showTTLStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTTLStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTTLHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(showDevicesStatement.hasSgCol() ? DatasetHeaderFactory.getShowDevicesWithSgHeader() : DatasetHeaderFactory.getShowDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowCluster(ShowClusterStatement showClusterStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showClusterStatement);
        if (showClusterStatement.isDetails()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterDetailsHeader());
        } else {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterHeader());
        }
        return analysis;
    }

    @Override
    public Analysis visitCountStorageGroup(CountStorageGroupStatement countStorageGroupStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countStorageGroupStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountStorageGroupHeader());
        return analysis;
    }

    @Override
    public Analysis visitSchemaFetch(SchemaFetchStatement schemaFetchStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(schemaFetchStatement);
        SchemaPartition schemaPartition = this.partitionFetcher.getSchemaPartition(schemaFetchStatement.getPatternTree());
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countLevelTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countLevelTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountLevelTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countStatement.getPathPattern());
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartitionWithLevel(patternTree, countStatement.getLevel());
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountNodesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildPathsStatement, showChildPathsStatement.getPartialPath(), DatasetHeaderFactory.getShowChildPathsHeader());
    }

    @Override
    public Analysis visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildNodesStatement, showChildNodesStatement.getPartialPath(), DatasetHeaderFactory.getShowChildNodesHeader());
    }

    @Override
    public Analysis visitShowVersion(ShowVersionStatement showVersionStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showVersionStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowVersionHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private Analysis visitSchemaNodeManagementPartition(Statement statement, PartialPath path, DatasetHeader header) {
        Analysis analysis = new Analysis();
        analysis.setStatement(statement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(path);
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartition(patternTree);
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(header);
        return analysis;
    }

    @Override
    public Analysis visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(deleteDataStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath pathPattern : deleteDataStatement.getPathList()) {
            patternTree.appendPathPattern(pathPattern);
        }
        ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree);
        analysis.setSchemaTree(schemaTree);
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        HashSet deduplicatedDevicePaths = new HashSet();
        for (String devicePattern : patternTree.getAllDevicePatterns()) {
            try {
                schemaTree.getMatchedDevices(new PartialPath(devicePattern)).forEach(deviceSchemaInfo -> deduplicatedDevicePaths.add(deviceSchemaInfo.getDevicePath().getFullPath()));
            }
            catch (IllegalPathException illegalPathException) {}
        }
        deduplicatedDevicePaths.forEach(devicePath -> {
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDevicePath(devicePath);
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase((String)devicePath), key -> new ArrayList()).add(queryParam);
        });
        DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        analysis.setDataPartitionInfo(dataPartition);
        if (dataPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCreateSchemaTemplate(CreateSchemaTemplateStatement createTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        List<List<String>> measurementsList = createTemplateStatement.getMeasurements();
        for (List<String> measurements : measurementsList) {
            HashSet<String> measurementsSet = new HashSet<String>(measurements);
            if (measurementsSet.size() >= measurements.size()) continue;
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showNodesInSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowNodesInSchemaTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowSchemaTemplateHeader());
        return analysis;
    }

    private GroupByFilter initGroupByFilter(GroupByTimeComponent groupByTimeComponent) {
        if (groupByTimeComponent.isIntervalByMonth() || groupByTimeComponent.isSlidingStepByMonth()) {
            return new GroupByMonthFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), groupByTimeComponent.getStartTime(), groupByTimeComponent.getEndTime(), groupByTimeComponent.isSlidingStepByMonth(), groupByTimeComponent.isIntervalByMonth(), TimeZone.getTimeZone("+00:00"));
        }
        long startTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getStartTime() : groupByTimeComponent.getStartTime() + 1L;
        long endTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getEndTime() : groupByTimeComponent.getEndTime() + 1L;
        return new GroupByFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), startTime, endTime);
    }

    @Override
    public Analysis visitSetSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(setSchemaTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathSetTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathSetTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(activateTemplateStatement);
        PartialPath activatePath = activateTemplateStatement.getPath();
        Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(activatePath);
        if (templateSetInfo == null) {
            throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", activatePath.getFullPath()))));
        }
        analysis.setTemplateSetInfo((Pair<Template, List<PartialPath>>)new Pair((Object)((Template)templateSetInfo.left), Collections.singletonList((PartialPath)templateSetInfo.right)));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(activatePath.concatNode("*"));
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(batchActivateTemplateStatement);
        HashMap<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap = new HashMap<PartialPath, Pair<Template, PartialPath>>(batchActivateTemplateStatement.getPaths().size());
        for (PartialPath partialPath : batchActivateTemplateStatement.getDevicePathList()) {
            Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(partialPath);
            if (templateSetInfo == null) {
                throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", partialPath.getFullPath()))));
            }
            deviceTemplateSetInfoMap.put(partialPath, templateSetInfo);
        }
        analysis.setDeviceTemplateSetInfoMap(deviceTemplateSetInfoMap);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath devicePath : batchActivateTemplateStatement.getDevicePathList()) {
            patternTree.appendPathPattern(devicePath.concatNode("*"));
        }
        SchemaPartition schemaPartition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartition);
        return analysis;
    }

    @Override
    public Analysis visitInternalBatchActivateTemplate(InternalBatchActivateTemplateStatement internalBatchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalBatchActivateTemplateStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath activatePath : internalBatchActivateTemplateStatement.getDeviceMap().keySet()) {
            patternTree.appendPathPattern(activatePath.concatNode("*"));
        }
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathsUsingTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathsUsingTemplateHeader());
        Pair<Template, List<PartialPath>> templateSetInfo = this.schemaFetcher.getAllPathsSetTemplate(showPathsUsingTemplateStatement.getTemplateName());
        if (templateSetInfo == null || templateSetInfo.right == null || ((List)templateSetInfo.right).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setTemplateSetInfo(templateSetInfo);
        PathPatternTree patternTree = new PathPatternTree();
        PartialPath rawPathPattern = showPathsUsingTemplateStatement.getPathPattern();
        ArrayList<PartialPath> specifiedPatternList = new ArrayList<PartialPath>();
        ((List)templateSetInfo.right).forEach(setPath -> {
            for (PartialPath specifiedPattern : rawPathPattern.alterPrefixPath(setPath)) {
                patternTree.appendPathPattern(specifiedPattern);
                specifiedPatternList.add(specifiedPattern);
            }
        });
        if (specifiedPatternList.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setSpecifiedTemplateRelatedPathPatternList(specifiedPatternList);
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        if (partition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        return analysis;
    }

    @Override
    public Analysis visitShowPipeSinkType(ShowPipeSinkTypeStatement showPipeSinkTypeStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPipeSinkTypeStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPipeSinkTypeHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    @Override
    public Analysis visitShowQueries(ShowQueriesStatement showQueriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showQueriesStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowQueriesHeader());
        analysis.setVirtualSource(true);
        List<TDataNodeLocation> allRunningDataNodeLocations = this.getRunningDataNodeLocations();
        if (allRunningDataNodeLocations.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        if (allRunningDataNodeLocations.isEmpty()) {
            throw new StatementAnalyzeException("no Running DataNodes");
        }
        analysis.setRunningDataNodeLocations(allRunningDataNodeLocations);
        HashSet<Expression> sourceExpressions = new HashSet<Expression>();
        for (ColumnHeader columnHeader : analysis.getRespDatasetHeader().getColumnHeaders()) {
            sourceExpressions.add(TimeSeriesOperand.constructColumnHeaderExpression(columnHeader.getColumnName(), columnHeader.getColumnType()));
        }
        analysis.setSourceExpressions(sourceExpressions);
        sourceExpressions.forEach(expression -> this.analyzeExpression(analysis, (Expression)expression));
        this.analyzeWhere(analysis, showQueriesStatement);
        analysis.setMergeOrderParameter(new OrderByParameter(showQueriesStatement.getSortItemList()));
        return analysis;
    }

    private List<TDataNodeLocation> getRunningDataNodeLocations() {
        ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TGetDataNodeLocationsResp showDataNodesResp = client.getRunningDataNodeLocations();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new StatementAnalyzeException("An error occurred when executing getRunningDataNodeLocations():" + showDataNodesResp.getStatus().getMessage());
            }
            List list = showDataNodesResp.getDataNodeLocationList();
            if (client != null) {
                client.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getRunningDataNodeLocations():" + e.getMessage());
            }
        }
    }

    private void analyzeWhere(Analysis analysis, ShowQueriesStatement showQueriesStatement) {
        WhereCondition whereCondition = showQueriesStatement.getWhereCondition();
        if (whereCondition == null) {
            return;
        }
        Expression whereExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(whereCondition.getPredicate(), ColumnHeaderConstant.showQueriesColumnHeaders);
        TSDataType outputType = this.analyzeExpression(analysis, whereExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    private static /* synthetic */ Pair lambda$analyzeTsFile$16(boolean finalIsAligned, File tsFile, String o) {
        return new Pair((Object)finalIsAligned, (Object)tsFile);
    }
}

