/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryExecutionMetricSet
implements IMetricSet {
    public static final Map<String, MetricInfo> metricInfoMap = new HashMap<String, MetricInfo>();
    public static final String WAIT_FOR_DISPATCH = "wait_for_dispatch";
    public static final String DISPATCH_READ = "dispatch_read";
    public static final String LOCAL_EXECUTION_PLANNER = "local_execution_planner";
    public static final String QUERY_RESOURCE_INIT = "query_resource_init";
    public static final String GET_QUERY_RESOURCE_FROM_MEM = "get_query_resource_from_mem";
    public static final String DRIVER_INTERNAL_PROCESS = "driver_internal_process";
    public static final String WAIT_FOR_RESULT = "wait_for_result";
    public static final String AGGREGATION_FROM_RAW_DATA = "aggregation_from_raw_data";
    public static final String AGGREGATION_FROM_STATISTICS = "aggregation_from_statistics";

    public void bindTo(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.getOrCreateTimer(metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.getOrCreateTimer(metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
        }
    }

    static {
        metricInfoMap.put(WAIT_FOR_DISPATCH, new MetricInfo(MetricType.TIMER, Metric.DISPATCHER.toString(), new String[]{Tag.STAGE.toString(), WAIT_FOR_DISPATCH}));
        metricInfoMap.put(DISPATCH_READ, new MetricInfo(MetricType.TIMER, Metric.DISPATCHER.toString(), new String[]{Tag.STAGE.toString(), DISPATCH_READ}));
        metricInfoMap.put(LOCAL_EXECUTION_PLANNER, new MetricInfo(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), LOCAL_EXECUTION_PLANNER}));
        metricInfoMap.put(QUERY_RESOURCE_INIT, new MetricInfo(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), QUERY_RESOURCE_INIT}));
        metricInfoMap.put(GET_QUERY_RESOURCE_FROM_MEM, new MetricInfo(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), GET_QUERY_RESOURCE_FROM_MEM}));
        metricInfoMap.put(DRIVER_INTERNAL_PROCESS, new MetricInfo(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), DRIVER_INTERNAL_PROCESS}));
        metricInfoMap.put(WAIT_FOR_RESULT, new MetricInfo(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), WAIT_FOR_RESULT}));
        metricInfoMap.put(AGGREGATION_FROM_RAW_DATA, new MetricInfo(MetricType.TIMER, Metric.AGGREGATION.toString(), new String[]{Tag.FROM.toString(), "raw_data"}));
        metricInfoMap.put(AGGREGATION_FROM_STATISTICS, new MetricInfo(MetricType.TIMER, Metric.AGGREGATION.toString(), new String[]{Tag.FROM.toString(), "statistics"}));
    }
}

