/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.factory.SourceOperatorFactory;
import org.apache.iotdb.db.mpp.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesScanOperator
extends AbstractDataSourceOperator {
    private final TsBlockBuilder builder;
    private boolean finished = false;

    public SeriesScanOperator(OperatorContext context, PlanNodeId sourceId, PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions seriesScanOptions) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new SeriesScanUtil(seriesPath, scanOrder, seriesScanOptions, context.getInstanceContext());
        this.maxReturnSize = Math.min(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
        this.builder = new TsBlockBuilder(this.seriesScanUtil.getTsDataTypeList());
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.resultTsBlock = this.builder.build();
        this.builder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            while ((this.readPageData() || this.readChunkData() || this.readFileData()) && System.nanoTime() - start < maxRuntime && !this.builder.isFull()) {
            }
            this.finished = this.builder.isEmpty();
            return !this.finished;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.calculateMaxPeekMemory() - this.calculateMaxReturnSize();
    }

    private boolean readFileData() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(tsBlock)) continue;
            this.appendToBuilder(tsBlock);
            return true;
        }
        return false;
    }

    private void appendToBuilder(TsBlock tsBlock) {
        TimeColumnBuilder timeColumnBuilder = this.builder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        ColumnBuilder columnBuilder = this.builder.getColumnBuilder(0);
        Column column = tsBlock.getColumn(0);
        if (column.mayHaveNull()) {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                } else {
                    columnBuilder.write(column, i);
                }
                this.builder.declarePosition();
            }
        } else {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                columnBuilder.write(column, i);
                this.builder.declarePosition();
            }
        }
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    public static class SeriesScanOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final PartialPath seriesPath;
        private final Set<String> allSensors;
        private final Filter timeFilter;
        private final Filter valueFilter;
        private final boolean ascending;
        private boolean closed;

        public SeriesScanOperatorFactory(int operatorId, PlanNodeId sourceId, PartialPath seriesPath, Set<String> allSensors, Filter timeFilter, Filter valueFilter, boolean ascending) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.seriesPath = Objects.requireNonNull(seriesPath, "seriesPath is null");
            this.allSensors = Objects.requireNonNull(allSensors, "allSensors is null");
            this.timeFilter = timeFilter;
            this.valueFilter = valueFilter;
            this.ascending = ascending;
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        public PlanNodeId getPlanNodeId() {
            return this.sourceId;
        }

        public String getOperatorType() {
            return SeriesScanOperator.class.getSimpleName();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, this.getOperatorType());
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(this.allSensors);
            scanOptionsBuilder.withGlobalTimeFilter(this.timeFilter);
            scanOptionsBuilder.withQueryFilter(this.valueFilter);
            return new SeriesScanOperator(operatorContext, this.sourceId, this.seriesPath, this.ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

