/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema.source;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.read.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowNodesPlan;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodeSchemaSource
implements ISchemaSource<INodeSchemaInfo> {
    private final PartialPath pathPattern;
    private final int level;

    NodeSchemaSource(PartialPath pathPattern, int level) {
        this.pathPattern = pathPattern;
        this.level = level;
    }

    @Override
    public ISchemaReader<INodeSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        IShowNodesPlan showNodesPlan = -1 == this.level ? SchemaRegionReadPlanFactory.getShowNodesPlan(this.pathPattern.concatNode("*")) : SchemaRegionReadPlanFactory.getShowNodesPlan(this.pathPattern, this.level, false);
        try {
            return schemaRegion.getNodeReader(showNodesPlan);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return ColumnHeaderConstant.showChildPathsColumnHeaders;
    }

    @Override
    public void transformToTsBlockColumns(INodeSchemaInfo nodeSchemaInfo, TsBlockBuilder tsBlockBuilder, String database) {
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(nodeSchemaInfo.getFullPath()));
        tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(nodeSchemaInfo.getNodeType().getNodeType())));
        tsBlockBuilder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return false;
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return 0L;
    }
}

