/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.query.info.ISchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public class SchemaQueryScanOperator<T extends ISchemaInfo>
implements SourceOperator {
    private static final long MAX_SIZE = TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    protected PlanNodeId sourceId;
    protected OperatorContext operatorContext;
    private final ISchemaSource<T> schemaSource;
    protected int limit;
    protected int offset;
    protected PartialPath partialPath;
    protected boolean isPrefixPath;
    private String database;
    private final List<TSDataType> outputDataTypes;
    private ISchemaReader<T> schemaReader;

    protected SchemaQueryScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, boolean isPrefixPath, List<TSDataType> outputDataTypes) {
        this.operatorContext = operatorContext;
        this.limit = limit;
        this.offset = offset;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.sourceId = sourceId;
        this.outputDataTypes = outputDataTypes;
        this.schemaSource = null;
    }

    public SchemaQueryScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, ISchemaSource<T> schemaSource) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.schemaSource = schemaSource;
        this.outputDataTypes = schemaSource.getInfoQueryColumnHeaders().stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    protected ISchemaReader<T> createSchemaReader() {
        return this.schemaSource.getSchemaReader(((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion());
    }

    protected void setColumns(T element, TsBlockBuilder builder) {
        this.schemaSource.transformToTsBlockColumns(element, builder, this.getDatabase());
    }

    public PartialPath getPartialPath() {
        return this.partialPath;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrefixPath() {
        return this.isPrefixPath;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        while (this.schemaReader.hasNext()) {
            ISchemaInfo element = (ISchemaInfo)this.schemaReader.next();
            this.setColumns(element, tsBlockBuilder);
            if (tsBlockBuilder.getRetainedSizeInBytes() < MAX_SIZE) continue;
        }
        if (!this.schemaReader.isSuccess()) {
            throw new RuntimeException(this.schemaReader.getFailure());
        }
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.schemaReader == null) {
            this.schemaReader = this.createSchemaReader();
        }
        return this.schemaReader.hasNext();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    protected String getDatabase() {
        if (this.database == null) {
            this.database = ((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion().getStorageGroupFullPath();
        }
        return this.database;
    }

    @Override
    public void close() throws Exception {
        if (this.schemaReader != null) {
            this.schemaReader.close();
            this.schemaReader = null;
        }
    }
}

