/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class TagAggregationOperator
extends AbstractConsumeAllOperator {
    private final List<List<String>> groups;
    private final List<List<Aggregator>> groupedAggregators;
    private final int[] consumedIndices;
    private final TsBlockBuilder tsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;

    public TagAggregationOperator(OperatorContext operatorContext, List<List<String>> groups, List<List<Aggregator>> groupedAggregators, List<Operator> children, long maxReturnSize) {
        super(operatorContext, children);
        this.groups = (List)Validate.notNull(groups);
        this.groupedAggregators = (List)Validate.notNull(groupedAggregators);
        ArrayList<TSDataType> actualOutputColumnTypes = new ArrayList<TSDataType>();
        for (String ignored : groups.get(0)) {
            actualOutputColumnTypes.add(TSDataType.TEXT);
        }
        block1: for (int outputColumnIdx = 0; outputColumnIdx < groupedAggregators.get(0).size(); ++outputColumnIdx) {
            for (List<Aggregator> aggregators : groupedAggregators) {
                Aggregator aggregator = aggregators.get(outputColumnIdx);
                if (aggregator == null) continue;
                actualOutputColumnTypes.addAll(Arrays.asList(aggregator.getOutputType()));
                continue block1;
            }
        }
        this.tsBlockBuilder = new TsBlockBuilder(actualOutputColumnTypes);
        Arrays.fill(this.canCallNext, false);
        this.consumedIndices = new int[children.size()];
        this.maxRetainedSize = children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && !this.tsBlockBuilder.isFull() && this.prepareInput()) {
            this.processOneRow();
        }
        TsBlock tsBlock = null;
        if (this.tsBlockBuilder.getPositionCount() > 0) {
            tsBlock = this.tsBlockBuilder.build();
        }
        this.tsBlockBuilder.reset();
        return tsBlock;
    }

    private void processOneRow() {
        int i;
        TsBlock[] rowBlocks = new TsBlock[this.children.size()];
        for (i = 0; i < this.children.size(); ++i) {
            rowBlocks[i] = this.inputTsBlocks[i].getRegion(this.consumedIndices[i], 1);
        }
        for (int groupIdx = 0; groupIdx < this.groups.size(); ++groupIdx) {
            int i2;
            List<String> group = this.groups.get(groupIdx);
            List<Aggregator> aggregators = this.groupedAggregators.get(groupIdx);
            for (Aggregator aggregator : aggregators) {
                if (aggregator == null) continue;
                aggregator.reset();
                aggregator.processTsBlocks(rowBlocks);
            }
            TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
            timeColumnBuilder.writeLong(rowBlocks[0].getStartTime());
            ColumnBuilder[] columnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
            for (i2 = 0; i2 < group.size(); ++i2) {
                if (group.get(i2) == null) {
                    columnBuilders[i2].writeBinary(new Binary("NULL"));
                    continue;
                }
                columnBuilders[i2].writeBinary(new Binary(group.get(i2)));
            }
            for (i2 = 0; i2 < aggregators.size(); ++i2) {
                Aggregator aggregator = aggregators.get(i2);
                ColumnBuilder columnBuilder = columnBuilders[i2 + group.size()];
                if (aggregator == null) {
                    columnBuilder.appendNull();
                    continue;
                }
                aggregator.outputResult(new ColumnBuilder[]{columnBuilder});
            }
            this.tsBlockBuilder.declarePosition();
        }
        i = 0;
        while (i < this.children.size()) {
            int n = i++;
            this.consumedIndices[n] = this.consumedIndices[n] + 1;
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isEmpty(this.readyChildIndex) || ((Operator)this.children.get(this.readyChildIndex)).hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    protected boolean isEmpty(int index) {
        return this.inputTsBlocks[index] == null || this.consumedIndices[index] == this.inputTsBlocks[index].getPositionCount();
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.consumedIndices[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }
}

