/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.metadata.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowDevicesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowNodesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.read.IShowTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.INodeSchemaInfo;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.rescon.ISchemaRegionStatistics;
import org.apache.iotdb.db.metadata.template.Template;

public interface ISchemaRegion {
    public void init() throws MetadataException;

    public void clear();

    public void forceMlog();

    public ISchemaRegionStatistics getSchemaRegionStatistics();

    public ISchemaRegionMetric createSchemaRegionMetric();

    public SchemaRegionId getSchemaRegionId();

    public String getStorageGroupFullPath();

    public void deleteSchemaRegion() throws MetadataException;

    public boolean createSnapshot(File var1);

    public void loadSnapshot(File var1);

    public void createTimeseries(ICreateTimeSeriesPlan var1, long var2) throws MetadataException;

    public void createAlignedTimeSeries(ICreateAlignedTimeSeriesPlan var1) throws MetadataException;

    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath var1, List<String> var2, List<String> var3);

    public void checkSchemaQuota(PartialPath var1, int var2) throws SchemaQuotaExceededException;

    public long constructSchemaBlackList(PathPatternTree var1) throws MetadataException;

    public void rollbackSchemaBlackList(PathPatternTree var1) throws MetadataException;

    public Set<PartialPath> fetchSchemaBlackList(PathPatternTree var1) throws MetadataException;

    public void deleteTimeseriesInBlackList(PathPatternTree var1) throws MetadataException;

    public List<MeasurementPath> fetchSchema(PartialPath var1, Map<Integer, Template> var2, boolean var3) throws MetadataException;

    public void upsertAliasAndTagsAndAttributes(String var1, Map<String, String> var2, Map<String, String> var3, PartialPath var4) throws MetadataException, IOException;

    public void addAttributes(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void addTags(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void dropTagsOrAttributes(Set<String> var1, PartialPath var2) throws MetadataException, IOException;

    public void setTagsOrAttributesValue(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void renameTagOrAttributeKey(String var1, String var2, PartialPath var3) throws MetadataException, IOException;

    public void activateSchemaTemplate(IActivateTemplateInClusterPlan var1, Template var2) throws MetadataException;

    public long constructSchemaBlackListWithTemplate(IPreDeactivateTemplatePlan var1) throws MetadataException;

    public void rollbackSchemaBlackListWithTemplate(IRollbackPreDeactivateTemplatePlan var1) throws MetadataException;

    public void deactivateTemplateInBlackList(IDeactivateTemplatePlan var1) throws MetadataException;

    public long countPathsUsingTemplate(int var1, PathPatternTree var2) throws MetadataException;

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan var1) throws MetadataException;

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan var1) throws MetadataException;

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan var1) throws MetadataException;
}

