/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheMemoryManager;
import org.apache.iotdb.db.metadata.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;

public class SchemaResourceManager {
    private SchemaResourceManager() {
    }

    public static void initSchemaResource(ISchemaEngineStatistics engineStatistics) {
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode().equals(SchemaEngineMode.Schema_File.toString())) {
            SchemaResourceManager.initSchemaFileModeResource(engineStatistics);
        }
    }

    public static void clearSchemaResource() {
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode().equals(SchemaEngineMode.Schema_File.toString())) {
            SchemaResourceManager.clearSchemaFileModeResource();
        }
    }

    private static void initSchemaFileModeResource(ISchemaEngineStatistics engineStatistics) {
        CacheMemoryManager.getInstance().init(engineStatistics);
    }

    private static void clearSchemaFileModeResource() {
        CacheMemoryManager.getInstance().clear();
    }
}

