/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaFileLogCorruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileLogReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaFileLogReader.class);
    private final File logFile;
    private final FileInputStream inputStream;

    public SchemaFileLogReader(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.inputStream = this.logFile.exists() ? new FileInputStream(this.logFile) : null;
    }

    public List<byte[]> collectUpdatedEntries() throws IOException, SchemaFileLogCorruptedException {
        if (this.inputStream == null || this.inputStream.getChannel().size() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> colBuffers = new ArrayList<byte[]>();
        byte[] tempBytes = new byte[16384];
        while (this.inputStream.available() > 0) {
            this.inputStream.read(tempBytes, 0, 1);
            if (tempBytes[0] == -1) {
                throw new SchemaFileLogCorruptedException(this.logFile.getAbsolutePath(), "COMMIT_MARK without PREPARE_MARK");
            }
            if (tempBytes[0] == -2) {
                if (this.inputStream.available() < 1) {
                    return colBuffers;
                }
                this.inputStream.read(tempBytes, 0, 1);
                if (tempBytes[0] != -1) {
                    throw new SchemaFileLogCorruptedException(this.logFile.getAbsolutePath(), "an extraneous byte rather than COMMIT_MARK after PREPARE_MARK");
                }
                colBuffers.clear();
                if (this.inputStream.read(tempBytes, 0, 1) < 0) {
                    return Collections.emptyList();
                }
            }
            if (this.inputStream.read(tempBytes, 1, tempBytes.length - 1) < tempBytes.length - 2) {
                throw new SchemaFileLogCorruptedException(this.logFile.getAbsolutePath(), "incomplete entry.");
            }
            colBuffers.add(tempBytes);
            tempBytes = new byte[16384];
        }
        throw new SchemaFileLogCorruptedException(this.logFile.getAbsolutePath(), "not ended by COMMIT_MARK nor PREPARE_MARK.");
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

