/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotPinnedException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheEntry;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.ICacheManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.MemManager;

public abstract class CacheManager
implements ICacheManager {
    private final MemManager memManager;
    private final NodeBuffer nodeBuffer = new NodeBuffer();

    public CacheManager(MemManager memManager) {
        this.memManager = memManager;
    }

    @Override
    public void initRootStatus(IMNode root) {
        this.pinMNodeWithMemStatusUpdate(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterMemoryRead(IMNode node) throws MNodeNotCachedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            throw new MNodeNotCachedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            if (this.getCacheEntry(node) == null) {
                throw new MNodeNotCachedException();
            }
            this.pinMNodeWithMemStatusUpdate(node);
        }
        this.updateCacheStatusAfterAccess(cacheEntry);
    }

    @Override
    public void updateCacheStatusAfterDiskRead(IMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        ICachedMNodeContainer.getBelongedContainer(node).addChildToCache(node);
        this.addToNodeCache(cacheEntry, node);
    }

    @Override
    public void updateCacheStatusAfterAppend(IMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        cacheEntry.setVolatile(true);
        ICachedMNodeContainer.getBelongedContainer(node).appendMNode(node);
        this.addToBufferAfterAppend(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBufferAfterAppend(IMNode node) {
        this.removeAncestorsFromCache(node);
        IMNode parent = node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        if (!cacheEntry.isVolatile()) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                if (!cacheEntry.isVolatile()) {
                    this.nodeBuffer.put(cacheEntry, parent);
                }
            }
        }
    }

    private void removeAncestorsFromCache(IMNode node) {
        IMNode parent = node.getParent();
        IMNode current = node;
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        while (!current.isStorageGroup() && this.isInNodeCache(cacheEntry)) {
            this.removeFromNodeCache(cacheEntry);
            current = parent;
            parent = parent.getParent();
            cacheEntry = this.getCacheEntry(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterUpdate(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (!cacheEntry.isVolatile()) {
            if (!node.isStorageGroup()) {
                CacheEntry cacheEntry2 = cacheEntry;
                synchronized (cacheEntry2) {
                    cacheEntry.setVolatile(true);
                }
                ICachedMNodeContainer.getBelongedContainer(node).updateMNode(node.getName());
                this.updateCacheStatusAfterUpdate(cacheEntry, node);
                this.removeFromNodeCache(cacheEntry);
            }
            this.addToBufferAfterUpdate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBufferAfterUpdate(IMNode node) {
        if (node.isStorageGroup()) {
            this.nodeBuffer.setUpdatedStorageGroupMNode(node.getAsStorageGroupMNode());
            return;
        }
        this.removeAncestorsFromCache(node);
        IMNode parent = node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        if (!cacheEntry.isVolatile()) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                if (!cacheEntry.isVolatile()) {
                    this.nodeBuffer.put(cacheEntry, parent);
                }
            }
        }
        this.nodeBuffer.remove(this.getCacheEntry(node));
    }

    @Override
    public void updateCacheStatusAfterPersist(IMNode node) {
        IMNode tmp = node;
        while (!tmp.isStorageGroup() && !this.isInNodeCache(this.getCacheEntry(tmp))) {
            this.addToNodeCache(this.getCacheEntry(tmp), tmp);
            tmp = tmp.getParent();
        }
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(node);
        Map<String, IMNode> persistedChildren = container.getNewChildBuffer();
        for (IMNode child : persistedChildren.values()) {
            this.updateCacheStatusAfterPersist(child, container);
        }
        persistedChildren = container.getUpdatedChildBuffer();
        for (IMNode child : persistedChildren.values()) {
            this.updateCacheStatusAfterPersist(child, container);
        }
    }

    private void updateCacheStatusAfterPersist(IMNode node, ICachedMNodeContainer container) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        cacheEntry.setVolatile(false);
        container.moveMNodeToCache(node.getName());
        this.addToNodeCache(cacheEntry, node);
    }

    @Override
    public IStorageGroupMNode collectUpdatedStorageGroupMNodes() {
        IStorageGroupMNode storageGroupMNode = this.nodeBuffer.getUpdatedStorageGroupMNode();
        this.nodeBuffer.setUpdatedStorageGroupMNode(null);
        return storageGroupMNode;
    }

    @Override
    public List<IMNode> collectVolatileMNodes() {
        ArrayList<IMNode> nodesToPersist = new ArrayList<IMNode>();
        this.nodeBuffer.forEachNode(node -> this.collectVolatileNodes((IMNode)node, (List<IMNode>)nodesToPersist));
        this.nodeBuffer.clear();
        return nodesToPersist;
    }

    private void collectVolatileNodes(IMNode node, List<IMNode> nodesToPersist) {
        Iterator<IMNode> bufferIterator = ICachedMNodeContainer.getCachedMNodeContainer(node).getChildrenBufferIterator();
        if (bufferIterator.hasNext()) {
            nodesToPersist.add(node);
        }
        while (bufferIterator.hasNext()) {
            IMNode child = bufferIterator.next();
            this.collectVolatileNodes(child, nodesToPersist);
        }
    }

    @Override
    public void remove(IMNode node) {
        this.removeRecursively(node);
    }

    private void removeOne(CacheEntry cacheEntry, IMNode node) {
        if (cacheEntry.isVolatile()) {
            this.nodeBuffer.remove(cacheEntry);
        } else {
            this.removeFromNodeCache(cacheEntry);
        }
        node.setCacheEntry(null);
        if (cacheEntry.isPinned()) {
            this.memManager.releasePinnedMemResource(node);
        }
        this.memManager.releaseMemResource(node);
    }

    private void removeRecursively(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return;
        }
        this.removeOne(cacheEntry, node);
        for (IMNode child : node.getChildren().values()) {
            this.removeRecursively(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean evict() {
        IMNode node = null;
        CacheEntry cacheEntry = null;
        ArrayList<IMNode> evictedMNodes = new ArrayList<IMNode>();
        boolean isSuccess = false;
        while (!isSuccess && (node = this.getPotentialNodeTobeEvicted()) != null) {
            CacheEntry cacheEntry2 = cacheEntry = this.getCacheEntry(node);
            synchronized (cacheEntry2) {
                if (!cacheEntry.isPinned() && this.isInNodeCache(cacheEntry)) {
                    String alias;
                    ICachedMNodeContainer.getBelongedContainer(node).evictMNode(node.getName());
                    if (node.isMeasurement() && (alias = node.getAsMeasurementMNode().getAlias()) != null) {
                        node.getParent().getAsEntityMNode().deleteAliasChild(alias);
                    }
                    this.removeFromNodeCache(this.getCacheEntry(node));
                    node.setCacheEntry(null);
                    evictedMNodes.add(node);
                    isSuccess = true;
                }
            }
        }
        if (node != null) {
            this.collectEvictedMNodes(node, evictedMNodes);
        }
        this.memManager.releaseMemResource(evictedMNodes);
        return !evictedMNodes.isEmpty();
    }

    private void collectEvictedMNodes(IMNode node, List<IMNode> evictedMNodes) {
        for (IMNode child : node.getChildren().values()) {
            this.removeFromNodeCache(this.getCacheEntry(child));
            child.setCacheEntry(null);
            evictedMNodes.add(child);
            this.collectEvictedMNodes(child, evictedMNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinMNode(IMNode node) throws MNodeNotPinnedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null || !cacheEntry.isPinned()) {
            throw new MNodeNotPinnedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry = this.getCacheEntry(node);
            if (cacheEntry == null || !cacheEntry.isPinned()) {
                throw new MNodeNotPinnedException();
            }
            this.doPin(node);
        }
    }

    private void pinMNodeWithMemStatusUpdate(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            this.memManager.requestPinnedMemResource(node);
            this.initCacheEntryForNode(node);
        } else if (!cacheEntry.isPinned()) {
            this.memManager.upgradeMemResource(node);
        }
        this.doPin(node);
    }

    private void doPin(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (!cacheEntry.isPinned()) {
            IMNode parent = node.getParent();
            if (!node.isStorageGroup()) {
                this.getCacheEntry(parent).pin();
            }
        }
        cacheEntry.pin();
    }

    @Override
    public boolean unPinMNode(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return false;
        }
        return this.doUnPin(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUnPin(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        boolean isPinStatusChanged = false;
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry.unPin();
            if (!cacheEntry.isPinned()) {
                isPinStatusChanged = true;
                this.memManager.releasePinnedMemResource(node);
            }
        }
        if (isPinStatusChanged && !node.isStorageGroup()) {
            this.doUnPin(node.getParent());
        }
        return isPinStatusChanged;
    }

    @Override
    public void clear(IMNode root) {
        this.clearMNodeInMemory(root);
        this.clearNodeCache();
        this.nodeBuffer.clear();
    }

    private void clearMNodeInMemory(IMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return;
        }
        if (cacheEntry.isPinned()) {
            this.memManager.releasePinnedMemResource(node);
        }
        this.memManager.releaseMemResource(node);
        Iterator<IMNode> iterator = ICachedMNodeContainer.getCachedMNodeContainer(node).getChildrenIterator();
        while (iterator.hasNext()) {
            this.clearMNodeInMemory(iterator.next());
        }
    }

    protected CacheEntry getCacheEntry(IMNode node) {
        return node.getCacheEntry();
    }

    @Override
    public long getBufferNodeNum() {
        return this.nodeBuffer.getBufferNodeNum();
    }

    protected void initCacheEntryForNode(IMNode node) {
        node.setCacheEntry(new CacheEntry());
    }

    protected abstract void updateCacheStatusAfterAccess(CacheEntry var1);

    protected abstract void updateCacheStatusAfterUpdate(CacheEntry var1, IMNode var2);

    protected abstract boolean isInNodeCache(CacheEntry var1);

    protected abstract void addToNodeCache(CacheEntry var1, IMNode var2);

    protected abstract void removeFromNodeCache(CacheEntry var1);

    protected abstract IMNode getPotentialNodeTobeEvicted();

    protected abstract void clearNodeCache();

    private static class NodeBuffer {
        private static final int MAP_NUM = 17;
        private IStorageGroupMNode updatedStorageGroupMNode;
        private Map<CacheEntry, IMNode>[] maps = new Map[17];

        NodeBuffer() {
            for (int i = 0; i < 17; ++i) {
                this.maps[i] = new ConcurrentHashMap<CacheEntry, IMNode>();
            }
        }

        public IStorageGroupMNode getUpdatedStorageGroupMNode() {
            return this.updatedStorageGroupMNode;
        }

        public void setUpdatedStorageGroupMNode(IStorageGroupMNode updatedStorageGroupMNode) {
            this.updatedStorageGroupMNode = updatedStorageGroupMNode;
        }

        void put(CacheEntry cacheEntry, IMNode node) {
            this.maps[this.getLoc(cacheEntry)].put(cacheEntry, node);
        }

        void remove(CacheEntry cacheEntry) {
            this.maps[this.getLoc(cacheEntry)].remove(cacheEntry);
        }

        void forEachNode(Consumer<IMNode> action) {
            for (Map<CacheEntry, IMNode> map : this.maps) {
                for (IMNode node : map.values()) {
                    action.accept(node);
                }
            }
        }

        long getBufferNodeNum() {
            long res = this.updatedStorageGroupMNode == null ? 0L : 1L;
            for (int i = 0; i < 17; ++i) {
                res += (long)this.maps[i].size();
            }
            return res;
        }

        void clear() {
            for (Map<CacheEntry, IMNode> map : this.maps) {
                map.clear();
            }
        }

        private int getLoc(CacheEntry cacheEntry) {
            int hash = cacheEntry.hashCode() % 17;
            return hash < 0 ? hash + 17 : hash;
        }
    }
}

