/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;

public class CachedMNodeContainer
implements ICachedMNodeContainer {
    private long segmentAddress = -1L;
    private Map<String, IMNode> childCache = null;
    private Map<String, IMNode> newChildBuffer = null;
    private Map<String, IMNode> updatedChildBuffer = null;

    @Override
    public int size() {
        return this.getSize(this.childCache) + this.getSize(this.newChildBuffer) + this.getSize(this.updatedChildBuffer);
    }

    private int getSize(Map<String, IMNode> map) {
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.childCache) && this.isEmpty(this.newChildBuffer) && this.isEmpty(this.updatedChildBuffer);
    }

    private boolean isEmpty(Map<String, IMNode> map) {
        return map == null || map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(this.childCache, key) || this.containsKey(this.newChildBuffer, key) || this.containsKey(this.updatedChildBuffer, key);
    }

    private boolean containsKey(Map<String, IMNode> map, Object key) {
        return map != null && map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(this.childCache, value) || this.containsValue(this.newChildBuffer, value) || this.containsValue(this.updatedChildBuffer, value);
    }

    private boolean containsValue(Map<String, IMNode> map, Object value) {
        return map != null && map.containsValue(value);
    }

    @Override
    public IMNode get(Object key) {
        IMNode result = this.get(this.childCache, key);
        if (result != null) {
            return result;
        }
        result = this.get(this.newChildBuffer, key);
        if (result != null) {
            return result;
        }
        return this.get(this.updatedChildBuffer, key);
    }

    private IMNode get(Map<String, IMNode> map, Object key) {
        return map == null ? null : map.get(key);
    }

    @Override
    @Nullable
    public synchronized IMNode put(String key, IMNode value) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, IMNode>();
        }
        return this.newChildBuffer.put(key, value);
    }

    @Override
    @Nullable
    public synchronized IMNode putIfAbsent(String key, IMNode value) {
        IMNode node = this.get(key);
        if (node == null) {
            if (this.newChildBuffer == null) {
                this.newChildBuffer = new ConcurrentHashMap<String, IMNode>();
            }
            node = this.newChildBuffer.put(key, value);
        }
        return node;
    }

    @Override
    public synchronized IMNode remove(Object key) {
        IMNode result = this.remove(this.childCache, key);
        if (result == null) {
            result = this.remove(this.newChildBuffer, key);
        }
        if (result == null) {
            result = this.remove(this.updatedChildBuffer, key);
        }
        return result;
    }

    private IMNode remove(Map<String, IMNode> map, Object key) {
        return map == null ? null : map.remove(key);
    }

    @Override
    public synchronized void putAll(@Nonnull Map<? extends String, ? extends IMNode> m) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, IMNode>();
        }
        this.newChildBuffer.putAll(m);
    }

    @Override
    public synchronized void clear() {
        this.childCache = null;
        this.newChildBuffer = null;
        this.updatedChildBuffer = null;
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.keySet(this.childCache));
        result.addAll(this.keySet(this.newChildBuffer));
        result.addAll(this.keySet(this.updatedChildBuffer));
        return result;
    }

    private Set<String> keySet(Map<String, IMNode> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Override
    @Nonnull
    public Collection<IMNode> values() {
        ArrayList<IMNode> result = new ArrayList<IMNode>();
        result.addAll(this.getValues(this.childCache));
        result.addAll(this.getValues(this.newChildBuffer));
        result.addAll(this.getValues(this.updatedChildBuffer));
        return result;
    }

    private Collection<IMNode> getValues(Map<String, IMNode> map) {
        return map == null ? Collections.emptyList() : map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, IMNode>> entrySet() {
        HashSet<Map.Entry<String, IMNode>> result = new HashSet<Map.Entry<String, IMNode>>();
        result.addAll(this.entrySet(this.childCache));
        result.addAll(this.entrySet(this.newChildBuffer));
        result.addAll(this.entrySet(this.updatedChildBuffer));
        return result;
    }

    private Set<Map.Entry<String, IMNode>> entrySet(Map<String, IMNode> map) {
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Override
    @Nullable
    public synchronized IMNode replace(String key, IMNode value) {
        IMNode replacedOne = this.replace(this.childCache, key, value);
        if (replacedOne == null) {
            replacedOne = this.replace(this.newChildBuffer, key, value);
        }
        if (replacedOne == null) {
            replacedOne = this.replace(this.updatedChildBuffer, key, value);
        }
        return replacedOne;
    }

    private IMNode replace(Map<String, IMNode> map, String key, IMNode value) {
        return map == null ? null : map.replace(key, value);
    }

    @Override
    public long getSegmentAddress() {
        return this.segmentAddress;
    }

    @Override
    public void setSegmentAddress(long segmentAddress) {
        this.segmentAddress = segmentAddress;
    }

    @Override
    public boolean isVolatile() {
        return this.segmentAddress == -1L;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public boolean isExpelled() {
        return !this.isVolatile() && this.isEmpty(this.childCache) && this.isEmpty(this.newChildBuffer) && this.isEmpty(this.updatedChildBuffer);
    }

    @Override
    public boolean hasChildInNewChildBuffer(String name) {
        return this.containsKey(this.newChildBuffer, name);
    }

    @Override
    public boolean hasChildInBuffer(String name) {
        return this.containsKey(this.updatedChildBuffer, name) || this.containsKey(this.newChildBuffer, name);
    }

    @Override
    public Iterator<IMNode> getChildrenIterator() {
        return new CachedMNodeContainerIterator();
    }

    @Override
    public Iterator<IMNode> getChildrenBufferIterator() {
        return new BufferIterator();
    }

    @Override
    public Iterator<IMNode> getNewChildBufferIterator() {
        return this.getNewChildBuffer().values().iterator();
    }

    @Override
    public Map<String, IMNode> getChildCache() {
        return this.childCache == null ? Collections.emptyMap() : this.childCache;
    }

    @Override
    public Map<String, IMNode> getNewChildBuffer() {
        return this.newChildBuffer == null ? Collections.emptyMap() : this.newChildBuffer;
    }

    @Override
    public Map<String, IMNode> getUpdatedChildBuffer() {
        return this.updatedChildBuffer == null ? Collections.emptyMap() : this.updatedChildBuffer;
    }

    @Override
    public synchronized void loadChildrenFromDisk(Map<String, IMNode> children) {
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, IMNode>();
        }
        this.childCache.putAll(children);
    }

    @Override
    public synchronized void addChildToCache(IMNode node) {
        String name = node.getName();
        if (this.containsKey(name)) {
            return;
        }
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, IMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void appendMNode(IMNode node) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, IMNode>();
        }
        this.newChildBuffer.put(node.getName(), node);
    }

    @Override
    public synchronized void updateMNode(String name) {
        IMNode node = this.remove(this.childCache, (Object)name);
        if (node != null) {
            if (this.updatedChildBuffer == null) {
                this.updatedChildBuffer = new ConcurrentHashMap<String, IMNode>();
            }
            this.updatedChildBuffer.put(name, node);
        }
    }

    @Override
    public synchronized void moveMNodeToCache(String name) {
        IMNode node = this.remove(this.newChildBuffer, (Object)name);
        if (node == null) {
            node = this.remove(this.updatedChildBuffer, (Object)name);
        }
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, IMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void evictMNode(String name) {
        this.remove(this.childCache, (Object)name);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CachedMNodeContainer:{");
        builder.append("childCache:[");
        for (IMNode node : this.getValues(this.childCache)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("newChildBuffer:[");
        for (IMNode node : this.getValues(this.newChildBuffer)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("updateChildBuffer:[");
        for (IMNode node : this.getValues(this.updatedChildBuffer)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("}");
        return builder.toString();
    }

    private class BufferIterator
    implements Iterator<IMNode> {
        Iterator<IMNode> iterator;
        Iterator<IMNode> newBufferIterator;
        Iterator<IMNode> updateBufferIterator;
        byte status = 0;

        BufferIterator() {
            this.newBufferIterator = CachedMNodeContainer.this.getNewChildBuffer().values().iterator();
            this.updateBufferIterator = CachedMNodeContainer.this.getUpdatedChildBuffer().values().iterator();
            this.iterator = this.newBufferIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (!this.iterator.hasNext()) {
                if (this.changeStatus()) continue;
                return false;
            }
            return true;
        }

        @Override
        public IMNode next() {
            return this.iterator.next();
        }

        private boolean changeStatus() {
            if (this.status == 0) {
                this.iterator = this.updateBufferIterator;
                this.status = 1;
                return true;
            }
            return false;
        }
    }

    private class CachedMNodeContainerIterator
    implements Iterator<IMNode> {
        Iterator<IMNode> iterator;
        byte status = 0;

        CachedMNodeContainerIterator() {
            this.iterator = CachedMNodeContainer.this.getChildCache().values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (!this.iterator.hasNext()) {
                if (this.changeStatus()) continue;
                return false;
            }
            return true;
        }

        @Override
        public IMNode next() {
            return this.iterator.next();
        }

        private boolean changeStatus() {
            switch (this.status) {
                case 0: {
                    this.iterator = CachedMNodeContainer.this.getNewChildBuffer().values().iterator();
                    this.status = 1;
                    return true;
                }
                case 1: {
                    this.iterator = CachedMNodeContainer.this.getUpdatedChildBuffer().values().iterator();
                    this.status = (byte)2;
                    return true;
                }
            }
            return false;
        }
    }
}

