/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;

public class DeviceEntry {
    IDeviceID deviceID;
    Map<String, SchemaEntry> measurementMap;
    boolean isAligned;
    Map<Long, Long> flushTimeMapOfEachPartition;
    long globalFlushTime = Long.MIN_VALUE;

    public DeviceEntry(IDeviceID deviceID) {
        this.deviceID = deviceID;
        this.measurementMap = new ConcurrentHashMap<String, SchemaEntry>();
        this.flushTimeMapOfEachPartition = new HashMap<Long, Long>();
    }

    public SchemaEntry getSchemaEntry(String measurementName) {
        return this.measurementMap.get(measurementName);
    }

    public void putSchemaEntry(String measurementName, SchemaEntry schemaEntry) {
        this.measurementMap.put(measurementName, schemaEntry);
    }

    public boolean contains(String measurementName) {
        return this.measurementMap.containsKey(measurementName);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public Long putFlushTimeMap(long timePartition, long flushTime) {
        return this.flushTimeMapOfEachPartition.put(timePartition, flushTime);
    }

    public long updateFlushTimeMap(long timePartition, long flushTime) {
        return this.flushTimeMapOfEachPartition.compute(timePartition, (k, v) -> v == null ? flushTime : Math.max(v, flushTime));
    }

    public void updateGlobalFlushTime(long flushTime) {
        this.globalFlushTime = Math.max(this.globalFlushTime, flushTime);
    }

    public void setGlobalFlushTime(long globalFlushTime) {
        this.globalFlushTime = globalFlushTime;
    }

    public Long getFlushTime(long timePartition) {
        return this.flushTimeMapOfEachPartition.get(timePartition);
    }

    public Long getFLushTimeWithDefaultValue(long timePartition) {
        return this.flushTimeMapOfEachPartition.getOrDefault(timePartition, Long.MIN_VALUE);
    }

    public long getGlobalFlushTime() {
        return this.globalFlushTime;
    }

    public void removePartition(long partitionId) {
        this.flushTimeMapOfEachPartition.remove(partitionId);
    }

    public void clearFlushTime() {
        this.flushTimeMapOfEachPartition.clear();
    }

    public Map<String, SchemaEntry> getMeasurementMap() {
        return this.measurementMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeviceEntry)) {
            return false;
        }
        DeviceEntry that = (DeviceEntry)o;
        return this.isAligned == that.isAligned && this.globalFlushTime == that.globalFlushTime && this.deviceID.equals(that.deviceID) && this.measurementMap.equals(that.measurementMap) && this.flushTimeMapOfEachPartition.equals(that.flushTimeMapOfEachPartition);
    }

    public int hashCode() {
        return Objects.hash(this.deviceID, this.measurementMap, this.isAligned, this.flushTimeMapOfEachPartition, this.globalFlushTime);
    }
}

