/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.utils.MQTTConnectionFactory;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.QoS;

public class MQTTConnectionPool
extends GenericObjectPool<BlockingConnection> {
    private static final Map<String, MQTTConnectionPool> MQTT_CONNECTION_POOL_MAP = new ConcurrentHashMap<String, MQTTConnectionPool>();
    private final AtomicInteger referenceCount = new AtomicInteger(0);

    public static MQTTConnectionPool getInstance(String host, int port, String username, MQTTConnectionFactory factory, int size) throws Exception {
        String key = host + ":" + port + "," + username;
        MQTTConnectionPool connectionPool = MQTT_CONNECTION_POOL_MAP.computeIfAbsent(key, k -> new MQTTConnectionPool(factory, size));
        if (connectionPool.referenceCount.getAndIncrement() == 0) {
            connectionPool.preparePool();
        }
        return connectionPool;
    }

    private MQTTConnectionPool(MQTTConnectionFactory factory, int size) {
        super((PooledObjectFactory)factory);
        this.setMaxTotal(Math.min(size, IoTDBDescriptor.getInstance().getConfig().getTriggerForwardMQTTPoolSize()));
        this.setMinIdle(1);
    }

    public void connect() throws Exception {
        BlockingConnection connection = (BlockingConnection)this.borrowObject();
        if (!connection.isConnected()) {
            connection.connect();
        }
        this.returnObject(connection);
    }

    public void clearAndClose() {
        this.clear();
        if (this.referenceCount.decrementAndGet() == 0) {
            this.close();
        }
    }

    public void publish(String topic, byte[] payload, QoS qos, boolean retain) throws Exception {
        BlockingConnection connection = (BlockingConnection)this.borrowObject();
        connection.publish(topic, payload, qos, retain);
        this.returnObject(connection);
    }
}

