/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.forward.mqtt;

import java.util.List;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.apache.iotdb.db.engine.trigger.sink.forward.mqtt.MQTTForwardConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.forward.mqtt.MQTTForwardEvent;
import org.apache.iotdb.db.engine.trigger.utils.MQTTConnectionFactory;
import org.apache.iotdb.db.engine.trigger.utils.MQTTConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTForwardHandler
implements Handler<MQTTForwardConfiguration, MQTTForwardEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTTForwardHandler.class);
    private MQTTConnectionPool connectionPool;
    private MQTTForwardConfiguration config;

    @Override
    public void open(MQTTForwardConfiguration config) throws Exception {
        this.config = config;
        MQTTConnectionFactory factory = new MQTTConnectionFactory(config.getHost(), config.getPort(), config.getUsername(), config.getPassword(), config.getConnectAttemptsMax(), config.getReconnectDelay());
        this.connectionPool = MQTTConnectionPool.getInstance(config.getHost(), config.getPort(), config.getUsername(), factory, config.getPoolSize());
    }

    @Override
    public void close() throws Exception {
        this.connectionPool.clearAndClose();
    }

    @Override
    public void onEvent(MQTTForwardEvent event) throws SinkException {
        try {
            this.connectionPool.publish(this.config.getTopic(), ("[" + event.toJsonString() + "]").getBytes(), this.config.getQos(), this.config.isRetain());
        }
        catch (Exception e) {
            if (this.config.isStopIfException()) {
                throw new SinkException("MQTT Forward Exception", e);
            }
            LOGGER.error("MQTT Forward Exception", (Throwable)e);
        }
    }

    @Override
    public void onEvent(List<MQTTForwardEvent> events) throws SinkException {
        StringBuilder sb = new StringBuilder().append("[");
        for (MQTTForwardEvent event : events) {
            sb.append(event.toJsonString()).append(", ");
        }
        sb.replace(sb.lastIndexOf(", "), sb.length(), "").append("]");
        try {
            this.connectionPool.publish(this.config.getTopic(), sb.toString().getBytes(), this.config.getQos(), this.config.isRetain());
        }
        catch (Exception e) {
            if (this.config.isStopIfException()) {
                throw new SinkException("MQTT Forward Exception", e);
            }
            LOGGER.error("MQTT Forward Exception", (Throwable)e);
        }
    }
}

