/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.snapshot.SnapshotLogger;
import org.apache.iotdb.db.engine.snapshot.exception.DirectoryNotLegalException;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotTaker.class);
    private final DataRegion dataRegion;
    private SnapshotLogger snapshotLogger;
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> unseqFiles;

    public SnapshotTaker(DataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }

    public boolean takeFullSnapshot(String snapshotDirPath, boolean flushBeforeSnapshot) throws DirectoryNotLegalException, IOException {
        File snapshotDir = new File(snapshotDirPath);
        String snapshotId = snapshotDir.getName();
        return this.takeFullSnapshot(snapshotDirPath, snapshotId, snapshotId, flushBeforeSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeFullSnapshot(String snapshotDirPath, String tempSnapshotId, String finalSnapshotId, boolean flushBeforeSnapshot) throws DirectoryNotLegalException, IOException {
        File snapshotDir = new File(snapshotDirPath);
        if (snapshotDir.exists() && snapshotDir.listFiles() != null && Objects.requireNonNull(snapshotDir.listFiles()).length > 0) {
            throw new DirectoryNotLegalException(String.format("%s already exists and is not empty", snapshotDirPath));
        }
        if (!snapshotDir.exists() && !snapshotDir.mkdirs()) {
            throw new IOException(String.format("Failed to create directory %s", snapshotDir));
        }
        File snapshotLog = new File(snapshotDir, "snapshot.log");
        try {
            boolean success;
            this.snapshotLogger = new SnapshotLogger(snapshotLog);
            this.snapshotLogger.logSnapshotId(finalSnapshotId);
            try {
                this.readLockTheFile();
                if (flushBeforeSnapshot) {
                    try {
                        this.dataRegion.writeLock("snapshotTaker");
                        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
                    }
                    finally {
                        this.dataRegion.writeUnlock();
                    }
                }
                success = (success = this.createSnapshot(this.seqFiles, tempSnapshotId)) && this.createSnapshot(this.unseqFiles, tempSnapshotId);
            }
            finally {
                this.readUnlockTheFile();
            }
            if (!success) {
                LOGGER.warn("Failed to take snapshot for {}-{}, clean up", (Object)this.dataRegion.getDatabaseName(), (Object)this.dataRegion.getDataRegionId());
                this.cleanUpWhenFail(finalSnapshotId);
            } else {
                this.snapshotLogger.logEnd();
                LOGGER.info("Successfully take snapshot for {}-{}, snapshot directory is {}", new Object[]{this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), snapshotDir.getParentFile().getAbsolutePath() + File.separator + finalSnapshotId});
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs when taking snapshot for {}-{}", new Object[]{this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), e});
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.snapshotLogger.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close snapshot logger", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLockTheFile() {
        TsFileManager manager = this.dataRegion.getTsFileManager();
        manager.readLock();
        try {
            this.seqFiles = manager.getTsFileList(true);
            this.unseqFiles = manager.getTsFileList(false);
            for (TsFileResource resource : this.seqFiles) {
                resource.readLock();
            }
            for (TsFileResource resource : this.unseqFiles) {
                resource.readLock();
            }
        }
        finally {
            manager.readUnlock();
        }
    }

    private void readUnlockTheFile() {
        for (TsFileResource resource : this.seqFiles) {
            resource.readUnlock();
        }
        for (TsFileResource resource : this.unseqFiles) {
            resource.readUnlock();
        }
    }

    private boolean createSnapshot(List<TsFileResource> resources, String snapshotId) {
        try {
            for (TsFileResource resource : resources) {
                if (!resource.isClosed()) continue;
                File tsFile = resource.getTsFile();
                if (!resource.isClosed()) continue;
                File snapshotTsFile = this.getSnapshotFilePathForTsFile(tsFile, snapshotId);
                this.createHardLink(snapshotTsFile, tsFile);
                this.createHardLink(new File(snapshotTsFile.getAbsolutePath() + ".resource"), new File(tsFile.getAbsolutePath() + ".resource"));
                if (!resource.getModFile().exists()) continue;
                this.createHardLink(new File(snapshotTsFile.getAbsolutePath() + ".mods"), new File(tsFile.getAbsolutePath() + ".mods"));
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Catch IOException when creating snapshot", (Throwable)e);
            return false;
        }
    }

    private void createHardLink(File target, File source) throws IOException {
        if (!target.getParentFile().exists()) {
            LOGGER.error("Hard link target dir {} doesn't exist", (Object)target.getParentFile());
        }
        if (!source.exists()) {
            LOGGER.error("Hard link source file {} doesn't exist", (Object)source);
        }
        Files.deleteIfExists(target.toPath());
        Files.createLink(target.toPath(), source.toPath());
        this.snapshotLogger.logFile(source);
    }

    public File getSnapshotFilePathForTsFile(File tsFile, String snapshotId) throws IOException {
        int i;
        String[] splittedPath = tsFile.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < splittedPath.length - 5; ++i) {
            stringBuilder.append(splittedPath[i]);
            stringBuilder.append(File.separator);
        }
        stringBuilder.append("snapshot");
        stringBuilder.append(File.separator);
        stringBuilder.append(this.dataRegion.getDatabaseName());
        stringBuilder.append("-");
        stringBuilder.append(this.dataRegion.getDataRegionId());
        stringBuilder.append(File.separator);
        stringBuilder.append(snapshotId);
        stringBuilder.append(File.separator);
        while (i < splittedPath.length - 1) {
            stringBuilder.append(splittedPath[i]);
            stringBuilder.append(File.separator);
            ++i;
        }
        File dir = new File(stringBuilder.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir.getAbsolutePath());
        }
        return new File(dir, tsFile.getName());
    }

    private void cleanUpWhenFail(String snapshotId) {
        LOGGER.info("Cleaning up snapshot dir for {}", (Object)snapshotId);
        for (String dataDir : IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File dataDirForThisSnapshot = new File(dataDir + File.separator + "snapshot" + File.separator + snapshotId);
            if (!dataDirForThisSnapshot.exists()) continue;
            try {
                FileUtils.recursiveDeleteFolder((String)dataDirForThisSnapshot.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete folder {} when cleaning up", (Object)dataDirForThisSnapshot.getAbsolutePath());
            }
        }
    }
}

