/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.execute.utils.log.TsFileIdentifier;

public class CompactionLogAnalyzer {
    private final File logFile;
    private final List<TsFileIdentifier> sourceFileInfos = new ArrayList<TsFileIdentifier>();
    private final List<TsFileIdentifier> targetFileInfos = new ArrayList<TsFileIdentifier>();
    private final List<TsFileIdentifier> deletedTargetFileInfos = new ArrayList<TsFileIdentifier>();
    private boolean isLogFromOld = false;

    public CompactionLogAnalyzer(File logFile) {
        this.logFile = logFile;
    }

    public void analyze() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                String fileInfo;
                if (currLine.startsWith("source")) {
                    fileInfo = currLine.replace("source ", "");
                    this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
                    continue;
                }
                if (currLine.startsWith("target")) {
                    fileInfo = currLine.replace("target ", "");
                    this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
                    continue;
                }
                fileInfo = currLine.replace("empty ", "");
                this.deletedTargetFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
            }
        }
    }

    public void analyzeOldInnerCompactionLog() throws IOException {
        this.isLogFromOld = true;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                switch (currLine) {
                    case "info-source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromOldInfoString(currLine));
                        break;
                    }
                    case "info-target": {
                        currLine = bufferedReader.readLine();
                        this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromOldInfoString(currLine));
                        break;
                    }
                    case "source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromFilePath(currLine));
                        break;
                    }
                    case "target": {
                        currLine = bufferedReader.readLine();
                        this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromFilePath(currLine));
                        break;
                    }
                    case "sequence": 
                    case "unsequence": {
                        break;
                    }
                }
            }
        }
    }

    public void analyzeOldCrossCompactionLog() throws IOException {
        this.isLogFromOld = true;
        boolean isSeqSource = true;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                if (currLine.equals("unseqFiles")) {
                    isSeqSource = false;
                    continue;
                }
                if (currLine.equals("seqFiles")) {
                    isSeqSource = true;
                    continue;
                }
                if (currLine.equals("merge start")) {
                    break;
                }
                this.analyzeOldFilePath(isSeqSource, currLine);
            }
        }
    }

    private void analyzeOldFilePath(boolean isSeqSource, String oldFilePath) {
        if (oldFilePath.startsWith("root")) {
            this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromOldInfoString(oldFilePath));
        } else {
            this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromFilePath(oldFilePath));
        }
        if (isSeqSource) {
            String targetFilePath = oldFilePath.replace(".tsfile", ".tsfile.merge");
            if (oldFilePath.startsWith("root")) {
                this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromOldInfoString(targetFilePath));
            } else {
                this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromFilePath(targetFilePath));
            }
        }
    }

    public List<TsFileIdentifier> getSourceFileInfos() {
        return this.sourceFileInfos;
    }

    public List<TsFileIdentifier> getTargetFileInfos() {
        return this.targetFileInfos;
    }

    public List<TsFileIdentifier> getDeletedTargetFileInfos() {
        return this.deletedTargetFileInfos;
    }

    public boolean isLogFromOld() {
        return this.isLogFromOld;
    }
}

