/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricNameTool;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardAutoGauge;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardCounter;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardGauge;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardHistogram;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardRate;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardTimer;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;

public class DropwizardMetricManager
extends AbstractMetricManager {
    MetricRegistry metricRegistry = new MetricRegistry();

    public Counter createCounter(MetricInfo metricInfo) {
        return new DropwizardCounter(this.metricRegistry.counter(DropwizardMetricNameTool.toFlatString(metricInfo)));
    }

    public <T> AutoGauge createAutoGauge(MetricInfo metricInfo, T obj, ToDoubleFunction<T> mapper) {
        DropwizardAutoGauge<T> dropwizardGauge = new DropwizardAutoGauge<T>(obj, mapper);
        this.metricRegistry.register(DropwizardMetricNameTool.toFlatString(metricInfo), dropwizardGauge);
        return dropwizardGauge;
    }

    public Gauge createGauge(MetricInfo metricInfo) {
        DropwizardGauge dropwizardGauge = new DropwizardGauge();
        this.metricRegistry.register(DropwizardMetricNameTool.toFlatString(metricInfo), dropwizardGauge.getDropwizardCachedGauge());
        return dropwizardGauge;
    }

    public Rate createRate(MetricInfo metricInfo) {
        return new DropwizardRate(this.metricRegistry.meter(DropwizardMetricNameTool.toFlatString(metricInfo)));
    }

    public Histogram createHistogram(MetricInfo metricInfo) {
        return new DropwizardHistogram(this.metricRegistry.histogram(DropwizardMetricNameTool.toFlatString(metricInfo)));
    }

    public Timer createTimer(MetricInfo metricInfo) {
        return new DropwizardTimer(this.metricRegistry.timer(DropwizardMetricNameTool.toFlatString(metricInfo)));
    }

    protected void removeMetric(MetricType type, MetricInfo metricInfo) {
        this.metricRegistry.remove(DropwizardMetricNameTool.toFlatString(metricInfo));
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public boolean stopFramework() {
        this.metricRegistry.removeMatching(MetricFilter.ALL);
        return true;
    }
}

