/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeShutdownHook.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int SHUTDOWN_REPORT_RETRY_NUM = 2;

    @Override
    public void run() {
        boolean isLeader = ConfigNode.getInstance().getConfigManager().getConsensusManager().isLeader();
        try {
            ConfigNode.getInstance().deactivate();
        }
        catch (IOException e) {
            LOGGER.error("Meet error when deactivate ConfigNode", (Throwable)e);
        }
        if (!isLeader) {
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.Unknown);
            boolean isReportSuccess = false;
            TEndPoint targetConfigNode = CONF.getTargetConfigNode();
            for (int retry = 0; retry < 2; ++retry) {
                TSStatus result = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(targetConfigNode, new TConfigNodeLocation(CONF.getConfigNodeId(), new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())), ConfigNodeRequestType.REPORT_CONFIG_NODE_SHUTDOWN);
                if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    isReportSuccess = true;
                    break;
                }
                if (result.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                targetConfigNode = result.getRedirectNode();
            }
            if (!isReportSuccess) {
                LOGGER.error("Reporting ConfigNode shutdown failed. The cluster will still take the current ConfigNode as Running for a few seconds.");
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("IoTDB-ConfigNode exits. Jvm memory usage: {}", (Object)MemUtils.bytesCntToStr((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        }
    }
}

