/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionGroupUtil;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTask;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteTimeSeriesState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListResp;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTimeSeriesProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteTimeSeriesState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTimeSeriesProcedure.class);
    private String queryId;
    private PathPatternTree patternTree;
    private ByteBuffer patternTreeBytes;
    private String requestMessage;

    public DeleteTimeSeriesProcedure() {
    }

    public DeleteTimeSeriesProcedure(String queryId, PathPatternTree patternTree) {
        this.queryId = queryId;
        this.setPatternTree(patternTree);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        if (targetSchemaRegionGroup.isEmpty()) {
            return 0L;
        }
        DeleteTimeSeriesRegionTask<TSStatus> constructBlackListTask = new DeleteTimeSeriesRegionTask<TSStatus>("construct schema black list", env, targetSchemaRegionGroup){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CONSTRUCT_SCHEMA_BLACK_LIST, new TConstructSchemaBlackListReq(consensusGroupIdList, DeleteTimeSeriesProcedure.this.patternTreeBytes), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                });
                return clientHandler.getResponseMap();
            }
        };
        constructBlackListTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        long preDeletedNum = 0L;
        for (List respList : constructBlackListTask.getResponseMap().values()) {
            for (TSStatus resp : respList) {
                preDeletedNum += Long.parseLong(resp.getMessage());
            }
        }
        return preDeletedNum;
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.patternTreeBytes), dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schema cache of timeseries {}", (Object)this.requestMessage);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate schema cache failed")));
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        this.deleteDataWithRawPathPattern(env);
    }

    private void deleteDataWithRawPathPattern(ConfigNodeProcedureEnv env) {
        this.executeDeleteData(env, this.patternTree);
        if (this.isFailed()) {
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_TIMESERIES_SCHEMA);
    }

    private void deleteDataWithResolvedPath(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeSchemaRegionGroupGroupIdMap = DataNodeRegionGroupUtil.getLeaderDataNodeRegionGroupMap(env.getConfigManager().getLoadManager().getLatestRegionLeaderMap(), relatedSchemaRegionGroup);
        for (Map.Entry<TDataNodeLocation, List<TConsensusGroupId>> entry : dataNodeSchemaRegionGroupGroupIdMap.entrySet()) {
            HashMap<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
            entry.getValue().forEach(consensusGroupId -> targetSchemaRegionGroup.put((TConsensusGroupId)consensusGroupId, (TRegionReplicaSet)relatedSchemaRegionGroup.get(consensusGroupId)));
            PathPatternTree patternTree = this.fetchSchemaBlackListOnTargetDataNode(env, targetSchemaRegionGroup);
            if (this.isFailed()) {
                return;
            }
            if (patternTree == null) {
                LOGGER.error("Failed to fetch schema black list for delete data of timeseries {} on {}", (Object)this.requestMessage, (Object)entry.getKey());
                this.setFailure(new ProcedureException(new MetadataException("Fetch schema black list forDelete data failed")));
                return;
            }
            if (patternTree.isEmpty()) continue;
            this.executeDeleteData(env, patternTree);
            if (!this.isFailed()) continue;
            return;
        }
        this.setNextState(DeleteTimeSeriesState.DELETE_TIMESERIES_SCHEMA);
    }

    private void executeDeleteData(ConfigNodeProcedureEnv env, final PathPatternTree patternTree) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedDataRegionGroup = env.getConfigManager().getRelatedDataRegionGroup(patternTree);
        if (relatedDataRegionGroup.isEmpty()) {
            return;
        }
        DeleteTimeSeriesRegionTask<TSStatus> deleteDataTask = new DeleteTimeSeriesRegionTask<TSStatus>("delete data", env, relatedDataRegionGroup, true){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.DELETE_DATA_FOR_DELETE_SCHEMA, new TDeleteDataForDeleteSchemaReq(new ArrayList<TConsensusGroupId>(consensusGroupIdList), DeleteTimeSeriesProcedure.this.preparePatternTreeBytesData(patternTree)), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                });
                return clientHandler.getResponseMap();
            }
        };
        deleteDataTask.execute();
    }

    private PathPatternTree fetchSchemaBlackListOnTargetDataNode(ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup) {
        DeleteTimeSeriesRegionTask<TFetchSchemaBlackListResp> fetchSchemaBlackListTask = new DeleteTimeSeriesRegionTask<TFetchSchemaBlackListResp>("fetch schema black list", env, targetSchemaRegionGroup){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.FETCH_SCHEMA_BLACK_LIST, new TFetchSchemaBlackListReq(consensusGroupIdList, DeleteTimeSeriesProcedure.this.patternTreeBytes), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                HashMap<Integer, TSStatus> statusMap = new HashMap<Integer, TSStatus>();
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                    statusMap.put((Integer)k, v.getStatus());
                });
                return statusMap;
            }
        };
        fetchSchemaBlackListTask.execute();
        if (this.isFailed()) {
            return null;
        }
        Map respMap = fetchSchemaBlackListTask.getResponseMap();
        PathPatternTree patternTree = new PathPatternTree();
        for (List respList : respMap.values()) {
            for (TFetchSchemaBlackListResp resp : respList) {
                for (PartialPath path : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(resp.getPathPatternTree())).getAllPathPatterns()) {
                    patternTree.appendFullPath(path);
                }
            }
        }
        patternTree.constructTree();
        return patternTree;
    }

    private void deleteTimeSeriesSchema(ConfigNodeProcedureEnv env) {
        DeleteTimeSeriesRegionTask<TSStatus> deleteTimeSeriesTask = new DeleteTimeSeriesRegionTask<TSStatus>("delete timeseries schema", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree)){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.DELETE_TIMESERIES, new TDeleteTimeSeriesReq(consensusGroupIdList, DeleteTimeSeriesProcedure.this.patternTreeBytes), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                });
                return clientHandler.getResponseMap();
            }
        };
        deleteTimeSeriesTask.execute();
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteTimeSeriesState deleteTimeSeriesState) throws IOException, InterruptedException, ProcedureException {
        DeleteTimeSeriesRegionTask<TSStatus> rollbackStateTask = new DeleteTimeSeriesRegionTask<TSStatus>("roll back schema black list", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree)){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.ROLLBACK_SCHEMA_BLACK_LIST, new TRollbackSchemaBlackListReq(consensusGroupIdList, DeleteTimeSeriesProcedure.this.patternTreeBytes), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                });
                return clientHandler.getResponseMap();
            }
        };
        rollbackStateTask.execute();
    }

    @Override
    protected boolean isRollbackSupported(DeleteTimeSeriesState deleteTimeSeriesState) {
        return true;
    }

    @Override
    protected DeleteTimeSeriesState getState(int stateId) {
        return DeleteTimeSeriesState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteTimeSeriesState deleteTimeSeriesState) {
        return deleteTimeSeriesState.ordinal();
    }

    @Override
    protected DeleteTimeSeriesState getInitialState() {
        return DeleteTimeSeriesState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
        this.requestMessage = patternTree.getAllPathPatterns().toString();
        this.patternTreeBytes = this.preparePatternTreeBytesData(patternTree);
    }

    private ByteBuffer preparePatternTreeBytesData(PathPatternTree patternTree) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DELETE_TIMESERIES_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.patternTree.serialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.setPatternTree(PathPatternTree.deserialize((ByteBuffer)byteBuffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteTimeSeriesProcedure that = (DeleteTimeSeriesProcedure)o;
        return this.getProcId() == that.getProcId() && this.getState() == that.getState() && this.patternTree.equals(that.patternTree);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.patternTree});
    }

    private abstract class DeleteTimeSeriesRegionTask<T>
    extends DataNodeRegionTask<T> {
        private final String taskName;

        DeleteTimeSeriesRegionTask(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup) {
            super(env, targetSchemaRegionGroup, false);
            this.taskName = taskName;
        }

        DeleteTimeSeriesRegionTask(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, boolean executeOnAllReplicaset) {
            super(env, targetSchemaRegionGroup, executeOnAllReplicaset);
            this.taskName = taskName;
        }

        @Override
        protected boolean hasFailure() {
            return DeleteTimeSeriesProcedure.this.isFailed();
        }

        @Override
        protected void onExecutionFailure(TDataNodeLocation dataNodeLocation) {
            LOGGER.error("Failed to execute [{}] of delete timeseries {} on {}", new Object[]{this.taskName, DeleteTimeSeriesProcedure.this.requestMessage, dataNodeLocation});
            DeleteTimeSeriesProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Delete timeseries %s failed when [%s]", DeleteTimeSeriesProcedure.this.requestMessage, this.taskName))));
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId) {
            DeleteTimeSeriesProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Delete timeseries %s failed when [%s] because all replicaset of schemaRegion %s failed.", DeleteTimeSeriesProcedure.this.requestMessage, this.taskName, consensusGroupId.id))));
        }
    }
}

