/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.cq;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.cq.CQState;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ShowCQPlan;
import org.apache.iotdb.confignode.consensus.response.cq.ShowCQResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.cq.CQScheduleTask;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;
    private final ReadWriteLock lock;
    private ScheduledExecutorService executor;

    public CQManager(ConfigManager configManager) {
        this.configManager = configManager;
        this.lock = new ReentrantReadWriteLock();
        this.executor = IoTDBThreadPoolFactory.newScheduledThreadPool((int)CONF.getCqSubmitThread(), (String)"CQ-Scheduler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createCQ(TCreateCQReq req) {
        this.lock.readLock().lock();
        try {
            ScheduledExecutorService currentExecutor = this.executor;
            TSStatus tSStatus = this.configManager.getProcedureManager().createCQ(req, currentExecutor);
            return tSStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TSStatus dropCQ(TDropCQReq req) {
        ConsensusWriteResponse response = this.configManager.getConsensusManager().write(new DropCQPlan(req.cqId));
        if (response.getStatus() != null) {
            return response.getStatus();
        }
        LOGGER.warn("Unexpected error happened while dropping cq {}: ", (Object)req.cqId, (Object)response.getException());
        TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        res.setMessage(response.getErrorMessage());
        return res;
    }

    public TShowCQResp showCQ() {
        ConsensusReadResponse response = this.configManager.getConsensusManager().read(new ShowCQPlan());
        if (response.getDataset() != null) {
            return ((ShowCQResp)response.getDataset()).convertToRpcShowCQResp();
        }
        LOGGER.warn("Unexpected error happened while showing cq: ", (Throwable)response.getException());
        TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        res.setMessage(response.getException().toString());
        return new TShowCQResp(res, Collections.emptyList());
    }

    public ScheduledExecutorService getExecutor() {
        ScheduledExecutorService res;
        this.lock.readLock().lock();
        try {
            res = this.executor;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCQScheduler() {
        this.lock.writeLock().lock();
        try {
            try {
                if (this.executor != null) {
                    this.executor.shutdown();
                }
            }
            catch (Throwable t) {
                LOGGER.error("Error happened while shutting down previous cq schedule thread pool.", t);
            }
            this.executor = IoTDBThreadPoolFactory.newScheduledThreadPool((int)CONF.getCqSubmitThread(), (String)"CQ-Scheduler");
            List<CQInfo.CQEntry> allCQs = null;
            while (this.configManager.getConsensusManager() == null) {
                try {
                    LOGGER.info("consensus layer is not ready, sleep 1s...");
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Unexpected interruption during waiting for consensus layer ready.");
                }
            }
            while (allCQs == null && this.configManager.getConsensusManager().isLeader()) {
                ConsensusReadResponse response = this.configManager.getConsensusManager().read(new ShowCQPlan());
                if (response.getDataset() != null) {
                    allCQs = ((ShowCQResp)response.getDataset()).getCqList();
                    continue;
                }
                LOGGER.warn("Unexpected error happened while fetching cq list: ", (Throwable)response.getException());
            }
            if (allCQs != null) {
                for (CQInfo.CQEntry entry : allCQs) {
                    if (entry.getState() != CQState.ACTIVE) continue;
                    CQScheduleTask cqScheduleTask = new CQScheduleTask(entry, this.executor, this.configManager);
                    cqScheduleTask.submitSelf();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stopCQScheduler() {
        ScheduledExecutorService previous;
        this.lock.writeLock().lock();
        try {
            previous = this.executor;
            this.executor = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (previous != null) {
            previous.shutdown();
        }
    }
}

