/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailReq;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ShowTrailPlan
extends ConfigPhysicalPlan {
    private String modelId;
    private String trailId;

    public ShowTrailPlan() {
        super(ConfigPhysicalPlanType.ShowTrail);
    }

    public ShowTrailPlan(TShowTrailReq showTrailReq) {
        super(ConfigPhysicalPlanType.ShowTrail);
        this.modelId = showTrailReq.getModelId();
        if (showTrailReq.isSetTrailId()) {
            this.trailId = showTrailReq.getTrailId();
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean isSetTrailId() {
        return this.trailId != null;
    }

    public String getTrailId() {
        return this.trailId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)(this.trailId != null ? 1 : 0), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.trailId, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        boolean isSetTrailId = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (isSetTrailId) {
            this.trailId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShowTrailPlan that = (ShowTrailPlan)o;
        return this.modelId.equals(that.modelId) && Objects.equals(this.trailId, that.trailId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId, this.trailId);
    }
}

