/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerHistogramSnapshot
implements org.apache.iotdb.metrics.type.HistogramSnapshot {
    HistogramSnapshot histogramSnapshot;
    private final TimeUnit baseTimeUnit;

    public MicrometerTimerHistogramSnapshot(HistogramSnapshot histogramSnapshot, TimeUnit baseTimeUnit) {
        this.histogramSnapshot = histogramSnapshot;
        this.baseTimeUnit = baseTimeUnit;
    }

    public double getValue(double quantile) {
        int prevIndex = 0;
        for (int i = 0; i < this.histogramSnapshot.percentileValues().length; ++i) {
            if (this.histogramSnapshot.percentileValues()[i].percentile() <= quantile) {
                prevIndex = i;
            }
            if (this.histogramSnapshot.percentileValues()[i].percentile() >= quantile) break;
        }
        return this.histogramSnapshot.percentileValues()[prevIndex].value(this.baseTimeUnit);
    }

    public double[] getValues() {
        return Arrays.stream(this.histogramSnapshot.percentileValues()).mapToDouble(k -> k.value(this.baseTimeUnit)).toArray();
    }

    public int size() {
        return this.histogramSnapshot.percentileValues().length;
    }

    public double getMedian() {
        return this.getValue(0.5);
    }

    public double getMax() {
        return this.histogramSnapshot.max(this.baseTimeUnit);
    }

    public double getMean() {
        return this.histogramSnapshot.mean(this.baseTimeUnit);
    }

    public double getMin() {
        return this.getValue(0.0);
    }
}

