/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.iotdb.tsfile.exception.PathParseException;
import org.apache.iotdb.tsfile.read.common.parser.PathNodesGenerator;
import org.apache.iotdb.tsfile.read.common.parser.PathVisitor;

public class PathUtils {
    public static String[] splitPathToDetachedNodes(String path) throws IllegalPathException {
        if ("".equals(path)) {
            return new String[0];
        }
        try {
            return PathNodesGenerator.splitPathToNodes((String)path);
        }
        catch (PathParseException e) {
            throw new IllegalPathException(path);
        }
    }

    public static String[] isLegalPath(String path) throws IllegalPathException {
        try {
            return PathNodesGenerator.splitPathToNodes((String)path);
        }
        catch (PathParseException e) {
            throw new IllegalPathException(path);
        }
    }

    public static List<List<String>> checkIsLegalSingleMeasurementListsAndUpdate(List<List<String>> measurementLists) throws MetadataException {
        if (measurementLists == null) {
            return null;
        }
        HashMap<String, String> checkedMeasurements = new HashMap<String, String>();
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (List<String> measurements : measurementLists) {
            res.add(PathUtils.checkLegalSingleMeasurementsAndSkipDuplicate(measurements, checkedMeasurements));
        }
        return res;
    }

    public static List<String> checkLegalSingleMeasurementsAndSkipDuplicate(List<String> measurements, Map<String, String> checkedMeasurements) throws MetadataException {
        if (measurements == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String measurement : measurements) {
            if (measurement == null) {
                res.add(null);
                continue;
            }
            if (checkedMeasurements.get(measurement) != null) {
                res.add(checkedMeasurements.get(measurement));
                continue;
            }
            String checked = PathUtils.checkAndReturnSingleMeasurement(measurement);
            checkedMeasurements.put(measurement, checked);
            res.add(checked);
        }
        return res;
    }

    public static List<String> checkIsLegalSingleMeasurementsAndUpdate(List<String> measurements) throws MetadataException {
        if (measurements == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String measurement : measurements) {
            if (measurement == null) continue;
            res.add(PathUtils.checkAndReturnSingleMeasurement(measurement));
        }
        return res;
    }

    public static List<List<String>> checkIsLegalMeasurementListsAndUpdate(List<List<String>> measurementLists) throws IllegalPathException {
        if (measurementLists == null) {
            return null;
        }
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (List<String> measurementList : measurementLists) {
            res.add(PathUtils.checkIsLegalMeasurementsAndUpdate(measurementList));
        }
        return res;
    }

    public static List<String> checkIsLegalMeasurementsAndUpdate(List<String> measurements) throws IllegalPathException {
        if (measurements == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String measurement : measurements) {
            if (measurement == null) continue;
            res.add(PathUtils.isLegalPath(measurement)[0]);
        }
        return res;
    }

    public static String checkAndReturnSingleMeasurement(String measurement) throws IllegalPathException {
        if (measurement == null) {
            return null;
        }
        if (measurement.startsWith("`") && measurement.endsWith("`")) {
            if (PathUtils.checkBackQuotes(measurement.substring(1, measurement.length() - 1))) {
                return PathUtils.removeBackQuotesIfNecessary(measurement);
            }
            throw new IllegalPathException(measurement);
        }
        if (IoTDBConstant.reservedWords.contains(measurement.toUpperCase()) || PathUtils.isRealNumber(measurement) || !TsFileConstant.NODE_NAME_PATTERN.matcher(measurement).matches()) {
            throw new IllegalPathException(measurement);
        }
        return measurement;
    }

    public static boolean isRealNumber(String str) {
        return PathVisitor.isRealNumber((String)str);
    }

    public static boolean isStartWith(String deviceName, String storageGroup) {
        return deviceName.equals(storageGroup) || deviceName.startsWith(storageGroup + ".");
    }

    public static String removeBackQuotesIfNecessary(String measurement) {
        String unWrapped = measurement.substring(1, measurement.length() - 1);
        if (PathUtils.isRealNumber(unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
            return measurement;
        }
        return unWrapped;
    }

    private static boolean checkBackQuotes(String src) {
        int num = src.length() - src.replace("`", "").length();
        if (num % 2 == 1) {
            return false;
        }
        return src.length() == src.replace("``", "").length() + num;
    }
}

