/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFConcat
implements UDTF {
    private boolean seriesBehind;
    private final StringBuilder concatTargets = new StringBuilder();

    public void validate(UDFParameterValidator validator) throws Exception {
        int size = validator.getParameters().getChildExpressions().size();
        for (int i = 0; i < size; ++i) {
            validator.validateInputSeriesDataType(i, Type.TEXT);
        }
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        parameters.getAttributes().forEach((key, value) -> {
            if (key.startsWith("target") && value != null) {
                this.concatTargets.append((String)value);
            }
        });
        this.seriesBehind = parameters.getBooleanOrDefault("series_behind", false);
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        StringBuilder concatSeries = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            if (row.isNull(i)) continue;
            concatSeries.append(row.getString(i));
        }
        collector.putString(row.getTime(), this.seriesBehind ? concatSeries.insert(0, this.concatTargets).toString() : concatSeries.append((CharSequence)this.concatTargets).toString());
    }
}

