/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum BuiltinFunction {
    DIFF("diff");

    private final String functionName;
    private static final Set<String> NATIVE_FUNCTION_NAMES;
    public static final Set<String> DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS;

    private BuiltinFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    public static boolean isMappable(String name) {
        String functionName;
        switch (functionName = name.toLowerCase()) {
            case "diff": {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid BuiltInFunction: " + name);
    }

    static {
        NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.stream(BuiltinFunction.values()).map(BuiltinFunction::getFunctionName).collect(Collectors.toList()));
        DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS = ImmutableSet.of((Object)"diff");
    }
}

