/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.dfa.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.dfa.DFAState;

public class NFAGraph {
    private final List<IFAState> nfaStateList = new ArrayList<IFAState>();
    private final List<IFAState>[][] nfaTransitionTable;

    public NFAGraph(PartialPath pathPattern, boolean isPrefix, Map<String, IFATransition> transitionMap) {
        int i;
        this.nfaTransitionTable = new List[transitionMap.size()][pathPattern.getNodeLength() + 1];
        int curStateIndex = 0;
        this.nfaStateList.add(new DFAState(curStateIndex));
        for (i = 0; i < transitionMap.size(); ++i) {
            this.nfaTransitionTable[i][0] = new ArrayList<IFAState>();
        }
        for (i = 0; i < pathPattern.getNodeLength(); ++i) {
            DFAState dFAState;
            String node = pathPattern.getNodes()[i];
            if (i == pathPattern.getNodeLength() - 1) {
                ++curStateIndex;
                dFAState = new DFAState(curStateIndex, true);
            } else {
                ++curStateIndex;
                dFAState = new DFAState(curStateIndex);
            }
            DFAState state = dFAState;
            this.nfaStateList.add(state);
            for (int j = 0; j < transitionMap.size(); ++j) {
                this.nfaTransitionTable[j][curStateIndex] = new ArrayList<IFAState>();
            }
            if ("*".equals(node)) {
                for (IFATransition transition : transitionMap.values()) {
                    this.nfaTransitionTable[transition.getIndex()][curStateIndex - 1].add(state);
                }
            } else if ("**".equals(node)) {
                for (IFATransition transition : transitionMap.values()) {
                    this.nfaTransitionTable[transition.getIndex()][curStateIndex - 1].add(state);
                    this.nfaTransitionTable[transition.getIndex()][curStateIndex].add(state);
                }
            } else {
                this.nfaTransitionTable[transitionMap.get(node).getIndex()][curStateIndex - 1].add(state);
            }
            if (!isPrefix || i != pathPattern.getNodeLength() - 1) continue;
            for (IFATransition transition : transitionMap.values()) {
                this.nfaTransitionTable[transition.getIndex()][curStateIndex].add(state);
            }
        }
    }

    public void print(Map<String, IFATransition> transitionMap) {
        System.out.println();
        System.out.println();
        System.out.println("NFA:");
        System.out.println("==================================================================================================");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("|%-15s|", "State"));
        for (IFATransition transfer : transitionMap.values()) {
            stringBuilder.append(String.format("%-15s|", transfer.toString()));
        }
        stringBuilder.append(String.format("%-15s|", "Final"));
        System.out.println(stringBuilder);
        for (int i = 0; i < this.nfaStateList.size(); ++i) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("|%-15d|", i));
            for (IFATransition transition : transitionMap.values()) {
                stringBuilder.append(String.format("%-15s|", StringUtils.join((Collection)this.nfaTransitionTable[transition.getIndex()][i].stream().map(IFAState::getIndex).collect(Collectors.toList()), (String)",")));
            }
            stringBuilder.append(String.format("%-15s|", this.nfaStateList.get(i).isFinal()));
            System.out.println(stringBuilder);
        }
    }

    public List<IFAState> getTransitions(IFATransition transition, IFAState state) {
        return this.nfaTransitionTable[transition.getIndex()][state.getIndex()];
    }

    public int getStateSize() {
        return this.nfaStateList.size();
    }
}

