/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.MetricRegistry;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricManager;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardJmxReporter
implements JmxReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardJmxReporter.class);
    private AbstractMetricManager dropwizardMetricManager = null;
    private com.codahale.metrics.jmx.JmxReporter jmxReporter = null;

    public boolean start() {
        if (this.jmxReporter != null) {
            LOGGER.warn("Dropwizard JmxReporter already start!");
            return false;
        }
        try {
            this.jmxReporter = com.codahale.metrics.jmx.JmxReporter.forRegistry((MetricRegistry)((DropwizardMetricManager)this.dropwizardMetricManager).getMetricRegistry()).inDomain("org.apache.iotdb.metrics").build();
            this.jmxReporter.start();
        }
        catch (Exception e) {
            this.jmxReporter = null;
            LOGGER.warn("Dropwizard JmxReporter failed to start, because ", (Throwable)e);
            return false;
        }
        LOGGER.info("Dropwizard JmxReporter start!");
        return true;
    }

    public boolean stop() {
        try {
            if (this.jmxReporter != null) {
                this.jmxReporter.stop();
                this.jmxReporter = null;
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Dropwizard JmxReporter failed to stop, because ", (Throwable)e);
            return false;
        }
        LOGGER.info("Dropwizard JmxReporter stop!");
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.JMX;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
        this.dropwizardMetricManager = metricManager;
    }
}

