/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.IPatternFA;
import org.apache.iotdb.commons.path.fa.match.IStateMatchInfo;
import org.apache.iotdb.commons.path.fa.match.StateMultiMatchInfo;
import org.apache.iotdb.commons.path.fa.match.StateSingleMatchInfo;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeVisitor<N extends ITreeNode, R>
implements Iterator<R>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTreeVisitor.class);
    protected N root;
    protected final IPatternFA patternFA;
    private final Deque<VisitorStackEntry> visitorStack = new ArrayDeque<VisitorStackEntry>();
    private final List<AncestorStackEntry> ancestorStack = new ArrayList<AncestorStackEntry>();
    private int firstAncestorOfTraceback = -1;
    private IStateMatchInfo currentStateMatchInfo;
    private boolean shouldVisitSubtree;
    private Throwable throwable;
    private N nextMatchedNode;

    protected AbstractTreeVisitor() {
        this.root = null;
        this.patternFA = null;
    }

    protected AbstractTreeVisitor(N root, PartialPath pathPattern, boolean isPrefixMatch) {
        this.root = root;
        boolean usingDFA = false;
        for (String pathNode : pathPattern.getNodes()) {
            if ("**".equals(pathNode)) {
                usingDFA = true;
                continue;
            }
            if (pathNode.length() <= 1 || !pathNode.contains("*")) continue;
            usingDFA = false;
            break;
        }
        this.patternFA = usingDFA ? new IPatternFA.Builder().pattern(pathPattern).isPrefixMatch(isPrefixMatch).buildDFA() : new IPatternFA.Builder().pattern(pathPattern).isPrefixMatch(isPrefixMatch).buildNFA();
    }

    protected final void initStack() {
        IFAState initialState = this.patternFA.getInitialState();
        IFATransition transition = this.patternFA.getPreciseMatchTransition(initialState).get(this.root.getName());
        if (transition == null) {
            return;
        }
        IFAState rootState = this.patternFA.getNextState(initialState, transition);
        this.currentStateMatchInfo = new StateSingleMatchInfo(this.patternFA, rootState);
        this.visitorStack.push(new VisitorStackEntry(this.createChildrenIterator(this.root), 1));
        this.ancestorStack.add(new AncestorStackEntry(this, this.root, this.currentStateMatchInfo));
    }

    public void reset() {
        this.close();
        this.visitorStack.clear();
        this.ancestorStack.clear();
        this.nextMatchedNode = null;
        this.firstAncestorOfTraceback = -1;
        this.initStack();
    }

    @Override
    public void close() {
        if (this.nextMatchedNode != null && !this.shouldVisitSubtree) {
            this.releaseNode(this.nextMatchedNode);
        }
        while (!this.visitorStack.isEmpty()) {
            this.popStack();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.throwable == null && this.nextMatchedNode == null) {
            try {
                this.getNext();
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                this.setFailure(e);
            }
        }
        return this.throwable == null && this.nextMatchedNode != null;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R result = this.generateResult(this.nextMatchedNode);
        if (!this.shouldVisitSubtree) {
            this.releaseNode(this.nextMatchedNode);
        }
        this.nextMatchedNode = null;
        return result;
    }

    private void getNext() {
        this.nextMatchedNode = null;
        while (!this.visitorStack.isEmpty()) {
            VisitorStackEntry stackEntry = this.visitorStack.peek();
            AbstractChildrenIterator iterator = stackEntry.iterator;
            if (!iterator.hasNext()) {
                this.popStack();
                continue;
            }
            ITreeNode nextTempNode = (ITreeNode)iterator.next();
            this.shouldVisitSubtree = false;
            if (this.currentStateMatchInfo.hasFinalState()) {
                if (this.acceptFullMatchedNode(nextTempNode)) {
                    this.nextMatchedNode = nextTempNode;
                }
                this.shouldVisitSubtree = this.shouldVisitSubtreeOfFullMatchedNode(nextTempNode);
            } else {
                if (this.acceptInternalMatchedNode(nextTempNode)) {
                    this.nextMatchedNode = nextTempNode;
                }
                this.shouldVisitSubtree = this.shouldVisitSubtreeOfInternalMatchedNode(nextTempNode);
            }
            if (this.shouldVisitSubtree) {
                this.pushChildren(nextTempNode);
            } else if (this.nextMatchedNode != nextTempNode) {
                this.releaseNode(nextTempNode);
            }
            if (this.nextMatchedNode == null) continue;
            return;
        }
    }

    private void pushChildren(N parent) {
        this.visitorStack.push(new VisitorStackEntry(this.createChildrenIterator(parent), this.visitorStack.isEmpty() ? 1 : this.visitorStack.peek().level + 1));
        this.ancestorStack.add(new AncestorStackEntry(this, parent, this.currentStateMatchInfo));
    }

    private AbstractChildrenIterator createChildrenIterator(N parent) {
        if (this.firstAncestorOfTraceback > -1) {
            return new TraceBackChildrenIterator(this, parent, this.currentStateMatchInfo);
        }
        if (this.currentStateMatchInfo.hasOnlyPreciseMatchTransition()) {
            return new PreciseMatchChildrenIterator(this, (ITreeNode)parent, this.currentStateMatchInfo.getOneMatchedState());
        }
        if (this.currentStateMatchInfo.hasNoPreciseMatchTransition() && this.currentStateMatchInfo.isSingleFuzzyMatchTransition()) {
            return new SingleFuzzyMatchChildrenIterator(this, (ITreeNode)parent, this.currentStateMatchInfo.getOneMatchedState());
        }
        return new MultiMatchTransitionChildrenIterator(this, (ITreeNode)parent, this.currentStateMatchInfo.getOneMatchedState());
    }

    private void popStack() {
        VisitorStackEntry stackEntry = this.visitorStack.pop();
        stackEntry.iterator.close();
        if (!this.visitorStack.isEmpty() && this.visitorStack.peek().level < this.ancestorStack.size()) {
            AncestorStackEntry ancestorStackEntry = this.ancestorStack.remove(this.ancestorStack.size() - 1);
            this.releaseNode(ancestorStackEntry.node);
            if (this.ancestorStack.size() <= this.firstAncestorOfTraceback) {
                this.firstAncestorOfTraceback = -1;
            }
        }
    }

    protected PartialPath getParentPartialPath() {
        int size;
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator<AncestorStackEntry> iterator = this.ancestorStack.iterator();
        int n = size = this.shouldVisitSubtree ? this.ancestorStack.size() - 1 : this.ancestorStack.size();
        for (int i = 0; i < size; ++i) {
            if (!iterator.hasNext()) continue;
            nodeNames.add(iterator.next().node.getName());
        }
        return new PartialPath(nodeNames.toArray(new String[0]));
    }

    protected final PartialPath getPartialPathFromRootToNode(N node) {
        return new PartialPath(this.getFullPathFromRootToNode(node));
    }

    protected final String[] getFullPathFromRootToNode(N node) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (AncestorStackEntry entry : this.ancestorStack) {
            nodeNames.add(entry.node.getName());
            if (entry.node != node) continue;
            return nodeNames.toArray(new String[0]);
        }
        nodeNames.add(node.getName());
        return nodeNames.toArray(new String[0]);
    }

    protected final N getAncestorNodeByLevel(int level) {
        return (N)this.ancestorStack.get(level).node;
    }

    protected final N getParentOfNextMatchedNode() {
        if (this.shouldVisitSubtree) {
            return (N)this.ancestorStack.get(this.ancestorStack.size() - 2).node;
        }
        return (N)this.ancestorStack.get(this.ancestorStack.size() - 1).node;
    }

    protected final int getLevelOfNextMatchedNode() {
        if (this.shouldVisitSubtree) {
            return this.ancestorStack.size() - 1;
        }
        return this.ancestorStack.size();
    }

    protected final int getSizeOfAncestor() {
        return this.ancestorStack.size();
    }

    protected void setFailure(Throwable e) {
        this.throwable = e;
    }

    public Throwable getFailure() {
        return this.throwable;
    }

    public boolean isSuccess() {
        return this.throwable == null;
    }

    protected abstract N getChild(N var1, String var2) throws Exception;

    protected abstract Iterator<N> getChildrenIterator(N var1) throws Exception;

    protected void releaseNode(N node) {
    }

    protected void releaseNodeIterator(Iterator<N> nodeIterator) {
    }

    protected abstract boolean shouldVisitSubtreeOfInternalMatchedNode(N var1);

    protected abstract boolean shouldVisitSubtreeOfFullMatchedNode(N var1);

    protected abstract boolean acceptInternalMatchedNode(N var1);

    protected abstract boolean acceptFullMatchedNode(N var1);

    protected abstract R generateResult(N var1);

    protected IFAState tryGetNextState(N node, IFAState sourceState, Map<String, IFATransition> preciseMatchTransitionMap) {
        IFATransition transition = preciseMatchTransitionMap.get(node.getName());
        if (transition == null) {
            return null;
        }
        return this.patternFA.getNextState(sourceState, transition);
    }

    protected IFAState tryGetNextState(N node, IFAState sourceState, IFATransition transition) {
        if (transition.isMatch(node.getName())) {
            return this.patternFA.getNextState(sourceState, transition);
        }
        return null;
    }

    protected abstract boolean mayTargetNodeType(N var1);

    private static class TraceBackChildrenIterator
    extends AbstractChildrenIterator {
        private final N parent;
        private final IStateMatchInfo sourceStateMatchInfo;
        private Iterator<N> iterator;
        final /* synthetic */ AbstractTreeVisitor this$0;

        TraceBackChildrenIterator(N parent, IStateMatchInfo sourceStateMatchInfo) {
            this.this$0 = var1_1;
            this.sourceStateMatchInfo = sourceStateMatchInfo;
            this.parent = parent;
        }

        @Override
        protected void getNext() throws Exception {
            if (this.iterator == null) {
                this.iterator = this.this$0.getChildrenIterator(this.parent);
            }
            while (this.iterator.hasNext()) {
                Iterator<IFATransition> transitionIterator;
                IFAState sourceState;
                int i;
                ITreeNode child = (ITreeNode)this.iterator.next();
                StateMultiMatchInfo stateMatchInfo = new StateMultiMatchInfo(this.this$0.patternFA);
                if (this.this$0.mayTargetNodeType(child)) {
                    for (i = 0; i < this.sourceStateMatchInfo.getMatchedStateSize(); ++i) {
                        sourceState = this.sourceStateMatchInfo.getMatchedState(i);
                        transitionIterator = this.tryGetNextMatchedState(child, sourceState, stateMatchInfo, true);
                        if (stateMatchInfo.getMatchedStateSize() <= 0) continue;
                        stateMatchInfo.setSourceStateOrdinal(i);
                        stateMatchInfo.setSourceTransitionIterator(transitionIterator);
                        if (stateMatchInfo.hasFinalState()) break;
                    }
                    if (stateMatchInfo.getMatchedStateSize() == 0 || !stateMatchInfo.hasFinalState()) {
                        this.traceback(child, stateMatchInfo, this.sourceStateMatchInfo.getMatchedStateSize() - 1, true);
                        if (stateMatchInfo.getMatchedStateSize() == 0) {
                            this.this$0.releaseNode(child);
                            continue;
                        }
                    }
                } else {
                    for (i = 0; i < this.sourceStateMatchInfo.getMatchedStateSize(); ++i) {
                        sourceState = this.sourceStateMatchInfo.getMatchedState(i);
                        transitionIterator = this.tryGetNextMatchedState(child, sourceState, stateMatchInfo, false);
                        if (stateMatchInfo.getMatchedStateSize() <= 0) continue;
                        stateMatchInfo.setSourceStateOrdinal(i);
                        stateMatchInfo.setSourceTransitionIterator(transitionIterator);
                        break;
                    }
                    if (stateMatchInfo.getMatchedStateSize() == 0) {
                        this.traceback(child, stateMatchInfo, this.sourceStateMatchInfo.getMatchedStateSize() - 1, false);
                        if (stateMatchInfo.getMatchedStateSize() == 0) {
                            this.this$0.releaseNode(child);
                            continue;
                        }
                    }
                }
                this.saveResult(child, stateMatchInfo);
                return;
            }
        }

        private Iterator<IFATransition> tryGetNextMatchedState(N child, IFAState sourceState, IStateMatchInfo currentStateMatchInfo, boolean needFinalState) {
            IFAState matchedState;
            Map<String, IFATransition> preciseMatchTransitionMap = this.this$0.patternFA.getPreciseMatchTransition(sourceState);
            if (!preciseMatchTransitionMap.isEmpty() && (matchedState = this.this$0.tryGetNextState(child, sourceState, preciseMatchTransitionMap)) != null) {
                currentStateMatchInfo.addMatchedState(matchedState);
                if (!needFinalState || matchedState.isFinal()) {
                    return this.this$0.patternFA.getFuzzyMatchTransitionIterator(sourceState);
                }
            }
            Iterator<IFATransition> transitionIterator = this.this$0.patternFA.getFuzzyMatchTransitionIterator(sourceState);
            while (transitionIterator.hasNext()) {
                matchedState = this.this$0.tryGetNextState(child, sourceState, transitionIterator.next());
                if (matchedState == null) continue;
                currentStateMatchInfo.addMatchedState(matchedState);
                if (needFinalState && !matchedState.isFinal()) continue;
                return transitionIterator;
            }
            return transitionIterator;
        }

        private void traceback(N node, IStateMatchInfo stateMatchInfo, int checkedSourceStateOrdinal, boolean needFinalState) {
            IFAState sourceState = null;
            Iterator<IFATransition> transitionIterator = null;
            for (int i = this.this$0.ancestorStack.size() - 1; i >= this.this$0.firstAncestorOfTraceback; --i) {
                IStateMatchInfo parentStateMatchInfo = ((AncestorStackEntry)this.this$0.ancestorStack.get(i - 1)).stateMatchInfo;
                IStateMatchInfo currentStateMatchInfo = ((AncestorStackEntry)this.this$0.ancestorStack.get(i)).stateMatchInfo;
                if (currentStateMatchInfo.getSourceStateOrdinal() == parentStateMatchInfo.getMatchedStateSize()) continue;
                int currentNodeIndex = i;
                while (currentNodeIndex >= i) {
                    int sourceStateOrdinal;
                    Object currentNode;
                    parentStateMatchInfo = ((AncestorStackEntry)this.this$0.ancestorStack.get(currentNodeIndex - 1)).stateMatchInfo;
                    if (currentNodeIndex == this.this$0.ancestorStack.size()) {
                        currentNode = node;
                        currentStateMatchInfo = stateMatchInfo;
                    } else {
                        currentNode = ((AncestorStackEntry)this.this$0.ancestorStack.get(currentNodeIndex)).node;
                        currentStateMatchInfo = ((AncestorStackEntry)this.this$0.ancestorStack.get(currentNodeIndex)).stateMatchInfo;
                    }
                    IFAState matchedState = null;
                    if (currentNode == node) {
                        sourceStateOrdinal = checkedSourceStateOrdinal;
                    } else {
                        sourceStateOrdinal = currentStateMatchInfo.getSourceStateOrdinal();
                        if (sourceStateOrdinal == parentStateMatchInfo.getMatchedStateSize()) {
                            --currentNodeIndex;
                            continue;
                        }
                        sourceState = parentStateMatchInfo.getMatchedState(sourceStateOrdinal);
                        transitionIterator = currentStateMatchInfo.getSourceTransitionIterator();
                        while (transitionIterator.hasNext() && (matchedState = this.this$0.tryGetNextState(currentNode, sourceState, transitionIterator.next())) == null) {
                        }
                    }
                    if (matchedState == null) {
                        while (++sourceStateOrdinal < parentStateMatchInfo.getMatchedStateSize()) {
                            sourceState = parentStateMatchInfo.getMatchedState(sourceStateOrdinal);
                            int matchedStateSize = currentStateMatchInfo.getMatchedStateSize();
                            transitionIterator = this.tryGetNextMatchedState(currentNode, sourceState, currentStateMatchInfo, needFinalState);
                            if (matchedStateSize == currentStateMatchInfo.getMatchedStateSize()) continue;
                            matchedState = currentStateMatchInfo.getMatchedState(matchedStateSize);
                            currentStateMatchInfo.setSourceStateOrdinal(sourceStateOrdinal);
                            currentStateMatchInfo.setSourceTransitionIterator(transitionIterator);
                            break;
                        }
                        if (matchedState == null) {
                            currentStateMatchInfo.setSourceStateOrdinal(sourceStateOrdinal - 1);
                            currentStateMatchInfo.setSourceTransitionIterator(transitionIterator);
                            --currentNodeIndex;
                            continue;
                        }
                    }
                    currentStateMatchInfo.addMatchedState(matchedState);
                    if (currentNode == node) {
                        if (needFinalState && !currentStateMatchInfo.hasFinalState()) {
                            while (transitionIterator.hasNext()) {
                                matchedState = this.this$0.tryGetNextState(currentNode, sourceState, transitionIterator.next());
                                if (matchedState == null) continue;
                                currentStateMatchInfo.addMatchedState(matchedState);
                                if (!matchedState.isFinal()) continue;
                                return;
                            }
                            --currentNodeIndex;
                            continue;
                        }
                        return;
                    }
                    ++currentNodeIndex;
                }
            }
        }

        @Override
        protected void close() {
            super.close();
            if (this.iterator != null) {
                this.this$0.releaseNodeIterator(this.iterator);
            }
        }
    }

    private static class MultiMatchTransitionChildrenIterator
    extends AbstractChildrenIterator {
        private final IFAState sourceState;
        private final Map<String, IFATransition> preciseMatchTransitionMap;
        private final N parent;
        private Iterator<N> iterator;
        final /* synthetic */ AbstractTreeVisitor this$0;

        private MultiMatchTransitionChildrenIterator(N parent, IFAState sourceState) {
            this.this$0 = var1_1;
            this.sourceState = sourceState;
            this.preciseMatchTransitionMap = var1_1.patternFA.getPreciseMatchTransition(sourceState);
            this.parent = parent;
        }

        @Override
        protected void getNext() throws Exception {
            if (this.iterator == null) {
                this.iterator = this.this$0.getChildrenIterator(this.parent);
            }
            IFAState matchedState = null;
            while (this.iterator.hasNext()) {
                IStateMatchInfo stateMatchInfo;
                ITreeNode child = (ITreeNode)this.iterator.next();
                if (!this.preciseMatchTransitionMap.isEmpty()) {
                    matchedState = this.this$0.tryGetNextState(child, this.sourceState, this.preciseMatchTransitionMap);
                }
                Iterator<IFATransition> transitionIterator = this.this$0.patternFA.getFuzzyMatchTransitionIterator(this.sourceState);
                if (matchedState == null) {
                    while (transitionIterator.hasNext() && (matchedState = this.this$0.tryGetNextState(child, this.sourceState, transitionIterator.next())) == null) {
                    }
                    if (matchedState == null) {
                        this.this$0.releaseNode(child);
                        continue;
                    }
                }
                if (this.this$0.mayTargetNodeType(child) && !matchedState.isFinal()) {
                    if (this.this$0.patternFA.mayTransitionOverlap() && transitionIterator.hasNext()) {
                        stateMatchInfo = new StateMultiMatchInfo(this.this$0.patternFA, matchedState, transitionIterator);
                        this.this$0.firstAncestorOfTraceback = this.this$0.ancestorStack.size();
                        while (transitionIterator.hasNext()) {
                            matchedState = this.this$0.tryGetNextState(child, this.sourceState, transitionIterator.next());
                            if (matchedState == null) continue;
                            stateMatchInfo.addMatchedState(matchedState);
                            if (!matchedState.isFinal()) continue;
                            break;
                        }
                    } else {
                        stateMatchInfo = new StateSingleMatchInfo(this.this$0.patternFA, matchedState);
                    }
                } else if (this.this$0.patternFA.mayTransitionOverlap() && transitionIterator.hasNext()) {
                    stateMatchInfo = new StateMultiMatchInfo(this.this$0.patternFA, matchedState, transitionIterator);
                    this.this$0.firstAncestorOfTraceback = this.this$0.ancestorStack.size();
                } else {
                    stateMatchInfo = new StateSingleMatchInfo(this.this$0.patternFA, matchedState);
                }
                this.saveResult(child, stateMatchInfo);
                return;
            }
        }

        @Override
        protected void close() {
            super.close();
            if (this.iterator != null) {
                this.this$0.releaseNodeIterator(this.iterator);
            }
        }
    }

    private static class SingleFuzzyMatchChildrenIterator
    extends AbstractChildrenIterator {
        private final IFAState sourceState;
        private final IFATransition transition;
        private final StateSingleMatchInfo stateMatchInfo;
        private final N parent;
        private Iterator<N> childrenIterator;
        final /* synthetic */ AbstractTreeVisitor this$0;

        private SingleFuzzyMatchChildrenIterator(N parent, IFAState sourceState) {
            this.this$0 = var1_1;
            this.sourceState = sourceState;
            this.transition = var1_1.patternFA.getFuzzyMatchTransitionIterator(sourceState).next();
            this.stateMatchInfo = new StateSingleMatchInfo(var1_1.patternFA, var1_1.patternFA.getNextState(sourceState, this.transition));
            this.parent = parent;
        }

        @Override
        protected void getNext() throws Exception {
            if (this.childrenIterator == null) {
                this.childrenIterator = this.this$0.getChildrenIterator(this.parent);
            }
            while (this.childrenIterator.hasNext()) {
                ITreeNode child = (ITreeNode)this.childrenIterator.next();
                if (this.this$0.tryGetNextState(child, this.sourceState, this.transition) == null) {
                    this.this$0.releaseNode(child);
                    continue;
                }
                this.saveResult(child, this.stateMatchInfo);
                return;
            }
        }

        @Override
        protected void close() {
            super.close();
            if (this.childrenIterator != null) {
                this.this$0.releaseNodeIterator(this.childrenIterator);
            }
        }
    }

    private static class PreciseMatchChildrenIterator
    extends AbstractChildrenIterator {
        private final N parent;
        private final IFAState sourceState;
        private final Iterator<IFATransition> transitionIterator;
        final /* synthetic */ AbstractTreeVisitor this$0;

        private PreciseMatchChildrenIterator(N parent, IFAState sourceState) {
            this.this$0 = var1_1;
            this.parent = parent;
            this.sourceState = sourceState;
            this.transitionIterator = var1_1.patternFA.getPreciseMatchTransitionIterator(sourceState);
        }

        @Override
        protected void getNext() throws Exception {
            while (this.transitionIterator.hasNext()) {
                IFATransition transition = this.transitionIterator.next();
                Object child = this.this$0.getChild(this.parent, transition.getAcceptEvent());
                if (child == null) continue;
                this.saveResult(child, new StateSingleMatchInfo(this.this$0.patternFA, this.this$0.patternFA.getNextState(this.sourceState, transition)));
                return;
            }
        }
    }

    private abstract class AbstractChildrenIterator
    implements Iterator<N> {
        private N nextMatchedChild;

        private AbstractChildrenIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextMatchedChild == null) {
                try {
                    this.getNext();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.nextMatchedChild != null;
        }

        @Override
        public N next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.nextMatchedChild;
            this.nextMatchedChild = null;
            return result;
        }

        protected final void saveResult(N child, IStateMatchInfo stateMatchInfo) {
            this.nextMatchedChild = child;
            AbstractTreeVisitor.this.currentStateMatchInfo = stateMatchInfo;
        }

        protected abstract void getNext() throws Exception;

        protected void close() {
            if (this.nextMatchedChild != null) {
                AbstractTreeVisitor.this.releaseNode(this.nextMatchedChild);
            }
        }
    }

    private static class AncestorStackEntry {
        private final N node;
        private final IStateMatchInfo stateMatchInfo;
        final /* synthetic */ AbstractTreeVisitor this$0;

        AncestorStackEntry(N node, IStateMatchInfo stateMatchInfo) {
            this.this$0 = var1_1;
            this.node = node;
            this.stateMatchInfo = stateMatchInfo;
        }
    }

    private class VisitorStackEntry {
        private final AbstractChildrenIterator iterator;
        private final int level;

        VisitorStackEntry(AbstractChildrenIterator iterator, int level) {
            this.iterator = iterator;
            this.level = level;
        }
    }
}

