/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.statemachine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.CreateRegionGroupsState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionGroupsProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, CreateRegionGroupsState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRegionGroupsProcedure.class);
    private TConsensusGroupType consensusGroupType;
    private CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
    private Map<TConsensusGroupId, TRegionReplicaSet> failedRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();

    public CreateRegionGroupsProcedure() {
    }

    public CreateRegionGroupsProcedure(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        this.consensusGroupType = consensusGroupType;
        this.createRegionGroupsPlan = createRegionGroupsPlan;
    }

    public CreateRegionGroupsProcedure(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan, Map<TConsensusGroupId, TRegionReplicaSet> failedRegionReplicaSets) {
        this.consensusGroupType = consensusGroupType;
        this.createRegionGroupsPlan = createRegionGroupsPlan;
        this.failedRegionReplicaSets = failedRegionReplicaSets;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateRegionGroupsState state) {
        switch (state) {
            case CREATE_REGION_GROUPS: {
                this.failedRegionReplicaSets = env.doRegionCreation(this.consensusGroupType, this.createRegionGroupsPlan);
                this.setNextState(CreateRegionGroupsState.SHUNT_REGION_REPLICAS);
                break;
            }
            case SHUNT_REGION_REPLICAS: {
                CreateRegionGroupsPlan persistPlan = new CreateRegionGroupsPlan();
                OfferRegionMaintainTasksPlan offerPlan = new OfferRegionMaintainTasksPlan();
                this.createRegionGroupsPlan.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> {
                    if (!this.failedRegionReplicaSets.containsKey(regionReplicaSet.getRegionId())) {
                        persistPlan.addRegionGroup((String)storageGroup, (TRegionReplicaSet)regionReplicaSet);
                        LOGGER.info("[CreateRegionGroups] All replicas of RegionGroup: {} are created successfully!", (Object)regionReplicaSet.getRegionId());
                    } else {
                        TRegionReplicaSet failedRegionReplicas = this.failedRegionReplicaSets.get(regionReplicaSet.getRegionId());
                        if (failedRegionReplicas.getDataNodeLocationsSize() <= (regionReplicaSet.getDataNodeLocationsSize() - 1) / 2) {
                            persistPlan.addRegionGroup((String)storageGroup, (TRegionReplicaSet)regionReplicaSet);
                            failedRegionReplicas.getDataNodeLocations().forEach(targetDataNode -> {
                                RegionCreateTask createTask = new RegionCreateTask((TDataNodeLocation)targetDataNode, (String)storageGroup, (TRegionReplicaSet)regionReplicaSet);
                                if (TConsensusGroupType.DataRegion.equals((Object)regionReplicaSet.getRegionId().getType())) {
                                    try {
                                        createTask.setTTL(env.getTTL((String)storageGroup));
                                    }
                                    catch (DatabaseNotExistsException e) {
                                        LOGGER.error("Can't get TTL", (Throwable)e);
                                    }
                                }
                                offerPlan.appendRegionMaintainTask(createTask);
                            });
                            LOGGER.info("[CreateRegionGroups] Failed to create some replicas of RegionGroup: {}, but this RegionGroup can still be used.", (Object)regionReplicaSet.getRegionId());
                        } else {
                            regionReplicaSet.getDataNodeLocations().forEach(targetDataNode -> {
                                if (!failedRegionReplicas.getDataNodeLocations().contains(targetDataNode)) {
                                    RegionDeleteTask deleteTask = new RegionDeleteTask((TDataNodeLocation)targetDataNode, regionReplicaSet.getRegionId());
                                    offerPlan.appendRegionMaintainTask(deleteTask);
                                }
                            });
                            LOGGER.info("[CreateRegionGroups] Failed to create most of replicas in RegionGroup: {}, The redundant replicas in this RegionGroup will be deleted.", (Object)regionReplicaSet.getRegionId());
                        }
                    }
                }));
                env.persistRegionGroup(persistPlan);
                env.getConfigManager().getConsensusManager().write(offerPlan);
                this.setNextState(CreateRegionGroupsState.ACTIVATE_REGION_GROUPS);
                break;
            }
            case ACTIVATE_REGION_GROUPS: {
                this.createRegionGroupsPlan.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> {
                    ConcurrentHashMap<Integer, RegionStatus> statusMap = new ConcurrentHashMap<Integer, RegionStatus>();
                    regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> statusMap.put(dataNodeLocation.getDataNodeId(), RegionStatus.Running));
                    if (!this.failedRegionReplicaSets.containsKey(regionReplicaSet.getRegionId())) {
                        env.activateRegionGroup(regionReplicaSet.getRegionId(), statusMap);
                    } else {
                        TRegionReplicaSet failedRegionReplicas = this.failedRegionReplicaSets.get(regionReplicaSet.getRegionId());
                        if (failedRegionReplicas.getDataNodeLocationsSize() <= (regionReplicaSet.getDataNodeLocationsSize() - 1) / 2) {
                            failedRegionReplicas.getDataNodeLocations().forEach(dataNodeLocation -> statusMap.replace(dataNodeLocation.getDataNodeId(), RegionStatus.Unknown));
                            env.activateRegionGroup(regionReplicaSet.getRegionId(), statusMap);
                        }
                    }
                }));
                this.setNextState(CreateRegionGroupsState.CREATE_REGION_GROUPS_FINISH);
                break;
            }
            case CREATE_REGION_GROUPS_FINISH: {
                env.broadcastRegionGroup();
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, CreateRegionGroupsState createRegionGroupsState) {
    }

    @Override
    protected CreateRegionGroupsState getState(int stateId) {
        return CreateRegionGroupsState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateRegionGroupsState createRegionGroupsState) {
        return createRegionGroupsState.ordinal();
    }

    @Override
    protected CreateRegionGroupsState getInitialState() {
        return CreateRegionGroupsState.CREATE_REGION_GROUPS;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_REGION_GROUPS.getTypeCode());
        super.serialize(stream);
        stream.writeInt(this.consensusGroupType.getValue());
        this.createRegionGroupsPlan.serializeForProcedure(stream);
        stream.writeInt(this.failedRegionReplicaSets.size());
        this.failedRegionReplicaSets.forEach((groupId, replica) -> {
            ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)groupId, (DataOutputStream)stream);
            ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)replica, (DataOutputStream)stream);
        });
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.consensusGroupType = TConsensusGroupType.findByValue((int)byteBuffer.getInt());
        try {
            this.createRegionGroupsPlan.deserializeForProcedure(byteBuffer);
            this.failedRegionReplicaSets.clear();
            int failedRegionsSize = byteBuffer.getInt();
            while (failedRegionsSize-- > 0) {
                TConsensusGroupId groupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
                TRegionReplicaSet replica = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)byteBuffer);
                this.failedRegionReplicaSets.put(groupId, replica);
            }
        }
        catch (Exception e) {
            LOGGER.error("Deserialize meets error in CreateRegionGroupsProcedure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRegionGroupsProcedure that = (CreateRegionGroupsProcedure)o;
        return this.consensusGroupType == that.consensusGroupType && this.createRegionGroupsPlan.equals(that.createRegionGroupsPlan) && this.failedRegionReplicaSets.equals(that.failedRegionReplicaSets);
    }

    public int hashCode() {
        return Objects.hash(this.consensusGroupType, this.createRegionGroupsPlan, this.failedRegionReplicaSets);
    }
}

