/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node.heartbeat;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.node.heartbeat.BaseNodeCache;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeStatistics;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;

public class DataNodeHeartbeatCache
extends BaseNodeCache {
    private volatile TLoadSample latestLoadSample = new TLoadSample();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCurrentStatistics() {
        long lastSendTime;
        NodeHeartbeatSample lastSample = null;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (!this.slidingWindow.isEmpty()) {
                lastSample = (NodeHeartbeatSample)this.slidingWindow.getLast();
            }
        }
        long l = lastSendTime = lastSample == null ? 0L : lastSample.getSendTimestamp();
        if (lastSample != null && lastSample.isSetLoadSample()) {
            this.latestLoadSample = lastSample.getLoadSample();
        }
        NodeStatus status = null;
        String statusReason = null;
        if (System.currentTimeMillis() - lastSendTime > 20000L) {
            status = NodeStatus.Unknown;
        } else if (lastSample != null) {
            status = lastSample.getStatus();
            statusReason = lastSample.getStatusReason();
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(loadScore, status, statusReason);
        if (!this.currentStatistics.equals(newStatistics)) {
            this.currentStatistics = newStatistics;
        }
    }

    public double getFreeDiskSpace() {
        return this.latestLoadSample.getFreeDiskSpace();
    }
}

