/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.ILeaderBalancer;

public class GreedyLeaderBalancer
implements ILeaderBalancer {
    private final Map<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
    private final Map<TConsensusGroupId, Integer> regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
    private final Set<Integer> disabledDataNodeSet = new HashSet<Integer>();

    @Override
    public Map<TConsensusGroupId, Integer> generateOptimalLeaderDistribution(Map<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap, Map<TConsensusGroupId, Integer> regionLeaderMap, Set<Integer> disabledDataNodeSet) {
        this.initialize(regionReplicaSetMap, regionLeaderMap, disabledDataNodeSet);
        Map<TConsensusGroupId, Integer> result = this.constructGreedyDistribution();
        this.clear();
        return result;
    }

    private void initialize(Map<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap, Map<TConsensusGroupId, Integer> regionLeaderMap, Set<Integer> disabledDataNodeSet) {
        this.regionReplicaSetMap.putAll(regionReplicaSetMap);
        this.regionLeaderMap.putAll(regionLeaderMap);
        this.disabledDataNodeSet.addAll(disabledDataNodeSet);
    }

    private void clear() {
        this.regionReplicaSetMap.clear();
        this.regionLeaderMap.clear();
        this.disabledDataNodeSet.clear();
    }

    private Map<TConsensusGroupId, Integer> constructGreedyDistribution() {
        ConcurrentHashMap leaderCounter = new ConcurrentHashMap();
        this.regionReplicaSetMap.forEach((regionGroupId, regionReplicaSet) -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> leaderCounter.putIfAbsent(dataNodeLocation.getDataNodeId(), new AtomicInteger(0))));
        this.regionLeaderMap.forEach((regionGroupId, leaderId) -> ((AtomicInteger)leaderCounter.get(leaderId)).getAndIncrement());
        for (TConsensusGroupId regionGroupId2 : this.regionReplicaSetMap.keySet()) {
            int leaderId2 = this.regionLeaderMap.get(regionGroupId2);
            if (!this.disabledDataNodeSet.contains(leaderId2)) continue;
            int newLeaderId = -1;
            int newLeaderWeight = Integer.MAX_VALUE;
            for (Object candidate : this.regionReplicaSetMap.get(regionGroupId2).getDataNodeLocations()) {
                int candidateId = candidate.getDataNodeId();
                int candidateWeight = ((AtomicInteger)leaderCounter.get(candidateId)).get();
                if (this.disabledDataNodeSet.contains(candidateId) || candidateWeight >= newLeaderWeight) continue;
                newLeaderId = candidateId;
                newLeaderWeight = candidateWeight;
            }
            if (newLeaderId == -1) continue;
            ((AtomicInteger)leaderCounter.get(leaderId2)).getAndDecrement();
            ((AtomicInteger)leaderCounter.get(newLeaderId)).getAndIncrement();
            this.regionLeaderMap.replace(regionGroupId2, newLeaderId);
        }
        ArrayList<WeightEntry> weightList = new ArrayList<WeightEntry>();
        for (TConsensusGroupId regionGroupId3 : this.regionReplicaSetMap.keySet()) {
            int leaderId3 = this.regionLeaderMap.get(regionGroupId3);
            int leaderWeight = ((AtomicInteger)leaderCounter.get(this.regionLeaderMap.get(regionGroupId3))).get();
            int followerWeight = Integer.MAX_VALUE;
            for (TDataNodeLocation follower : this.regionReplicaSetMap.get(regionGroupId3).getDataNodeLocations()) {
                int followerId = follower.getDataNodeId();
                if (followerId == leaderId3) continue;
                followerWeight = Math.min(followerWeight, ((AtomicInteger)leaderCounter.get(followerId)).get());
            }
            weightList.add(new WeightEntry(regionGroupId3, leaderWeight, followerWeight));
        }
        weightList.sort(WeightEntry.COMPARATOR);
        for (WeightEntry weightEntry : weightList) {
            TConsensusGroupId regionGroupId4 = weightEntry.regionGroupId;
            int leaderId4 = this.regionLeaderMap.get(regionGroupId4);
            int leaderWeight = ((AtomicInteger)leaderCounter.get(this.regionLeaderMap.get(regionGroupId4))).get();
            int newLeaderId = -1;
            int newLeaderWeight = Integer.MAX_VALUE;
            for (TDataNodeLocation candidate : this.regionReplicaSetMap.get(regionGroupId4).getDataNodeLocations()) {
                int candidateId = candidate.getDataNodeId();
                int candidateWeight = ((AtomicInteger)leaderCounter.get(candidateId)).get();
                if (this.disabledDataNodeSet.contains(candidateId) || candidateId == leaderId4 || candidateWeight >= newLeaderWeight) continue;
                newLeaderId = candidateId;
                newLeaderWeight = candidateWeight;
            }
            if (leaderWeight - newLeaderWeight <= 1) continue;
            ((AtomicInteger)leaderCounter.get(leaderId4)).getAndDecrement();
            ((AtomicInteger)leaderCounter.get(newLeaderId)).getAndIncrement();
            this.regionLeaderMap.replace(regionGroupId4, newLeaderId);
        }
        return new ConcurrentHashMap<TConsensusGroupId, Integer>(this.regionLeaderMap);
    }

    private static class WeightEntry {
        private final TConsensusGroupId regionGroupId;
        private final int firstKey;
        private final int secondKey;
        private static final Comparator<WeightEntry> COMPARATOR = (o1, o2) -> o1.firstKey == o2.firstKey ? o1.secondKey - o2.secondKey : o2.firstKey - o1.firstKey;

        private WeightEntry(TConsensusGroupId regionGroupId, int firstKey, int secondKey) {
            this.regionGroupId = regionGroupId;
            this.firstKey = firstKey;
            this.secondKey = secondKey;
        }
    }
}

