/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UpdateTriggersOnTransferNodesPlan
extends ConfigPhysicalPlan {
    private List<TDataNodeLocation> dataNodeLocations;

    public UpdateTriggersOnTransferNodesPlan() {
        super(ConfigPhysicalPlanType.UpdateTriggersOnTransferNodes);
    }

    public UpdateTriggersOnTransferNodesPlan(List<TDataNodeLocation> dataNodeLocations) {
        super(ConfigPhysicalPlanType.UpdateTriggersOnTransferNodes);
        this.dataNodeLocations = dataNodeLocations;
    }

    public List<TDataNodeLocation> getDataNodeLocations() {
        return this.dataNodeLocations;
    }

    public void setDataNodeLocations(List<TDataNodeLocation> dataNodeLocations) {
        this.dataNodeLocations = dataNodeLocations;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((int)this.dataNodeLocations.size(), (OutputStream)stream);
        for (TDataNodeLocation dataNodeLocation : this.dataNodeLocations) {
            ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)dataNodeLocation, (DataOutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size;
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>(size);
        for (size = ReadWriteIOUtils.readInt((ByteBuffer)buffer); size > 0; --size) {
            dataNodeLocations.add(ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer));
        }
        this.dataNodeLocations = dataNodeLocations;
    }
}

