/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.sync;

import java.util.Map;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.commons.sync.pipesink.IoTDBPipeSink;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeSinkFactory;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;

public class SyncPipeUtil {
    public static PipeSink parseCreatePipeSinkStatement(CreatePipeSinkStatement createPipeSinkStatement) throws PipeSinkException {
        PipeSink pipeSink;
        try {
            pipeSink = PipeSinkFactory.createPipeSink(createPipeSinkStatement.getPipeSinkType(), createPipeSinkStatement.getPipeSinkName());
        }
        catch (UnsupportedOperationException e) {
            throw new PipeSinkException(e.getMessage());
        }
        pipeSink.setAttribute(createPipeSinkStatement.getAttributes());
        return pipeSink;
    }

    public static PipeInfo parseCreatePipeStatementAsPipeInfo(CreatePipeStatement createPipeStatement, long pipeCreateTime) throws PipeException {
        boolean syncDelOp = false;
        for (Map.Entry<String, String> entry : createPipeStatement.getPipeAttributes().entrySet()) {
            String attributeKey = entry.getKey().toLowerCase();
            if ("syncdelop".equals(attributeKey)) {
                syncDelOp = Boolean.parseBoolean(entry.getValue());
                continue;
            }
            throw new PipeException(String.format("Can not recognition attribute %s", entry.getKey()));
        }
        return new TsFilePipeInfo(createPipeStatement.getPipeName(), createPipeStatement.getPipeSinkName(), pipeCreateTime, createPipeStatement.getStartTime(), syncDelOp);
    }

    public static Pipe parsePipeInfoAsPipe(PipeInfo pipeInfo, PipeSink pipeSink) throws PipeException {
        if (pipeInfo instanceof TsFilePipeInfo) {
            return new TsFilePipe(pipeInfo.getCreateTime(), pipeInfo.getPipeName(), pipeSink, ((TsFilePipeInfo)pipeInfo).getDataStartTimestamp(), ((TsFilePipeInfo)pipeInfo).isSyncDelOp());
        }
        throw new PipeException(String.format("Can not recognition pipeInfo type", new Object[0]));
    }

    public static PipeSink parseTPipeSinkInfoAsPipeSink(TPipeSinkInfo pipeSinkInfo) throws PipeSinkException {
        if (pipeSinkInfo.getPipeSinkType().equals(PipeSink.PipeSinkType.IoTDB.name())) {
            IoTDBPipeSink pipeSink = new IoTDBPipeSink(pipeSinkInfo.getPipeSinkName());
            pipeSink.setAttribute(pipeSinkInfo.getAttributes());
            return pipeSink;
        }
        throw new UnsupportedOperationException();
    }

    public static PipeInfo parseTCreatePipeReqAsPipeInfo(TCreatePipeReq pipeInfo, long pipeCreateTime) throws PipeException {
        boolean syncDelOp = false;
        for (Map.Entry entry : pipeInfo.getAttributes().entrySet()) {
            String attributeKey = ((String)entry.getKey()).toLowerCase();
            if ("syncdelop".equals(attributeKey)) {
                syncDelOp = Boolean.parseBoolean((String)entry.getValue());
                continue;
            }
            throw new PipeException(String.format("Can not recognition attribute %s", entry.getKey()));
        }
        return new TsFilePipeInfo(pipeInfo.getPipeName(), pipeInfo.getPipeSinkName(), pipeCreateTime, pipeInfo.getStartTime(), syncDelOp);
    }
}

