/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPipeSink
implements PipeSink {
    private static final Logger logger = LoggerFactory.getLogger(ExternalPipeSink.class);
    private static final PipeSink.PipeSinkType pipeSinkType = PipeSink.PipeSinkType.ExternalPipe;
    private String pipeSinkName;
    private String extPipeSinkTypeName;
    private Map<String, String> sinkParams;

    public ExternalPipeSink() {
    }

    public ExternalPipeSink(String pipeSinkName, String extPipeSinkTypeName) {
        this.pipeSinkName = pipeSinkName;
        this.extPipeSinkTypeName = extPipeSinkTypeName;
    }

    public void setAttribute(Map<String, String> params) throws PipeSinkException {
        String regex = "^'|'$|^\"|\"$";
        this.sinkParams = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).trim().replaceAll(regex, ""), (key1, key2) -> key2));
        try {
            ExtPipePluginRegister.getInstance().getWriteFactory(this.extPipeSinkTypeName).validateSinkParams(this.sinkParams);
        }
        catch (Exception e2) {
            throw new PipeSinkException(e2.getMessage());
        }
    }

    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    public PipeSink.PipeSinkType getType() {
        return pipeSinkType;
    }

    public String showAllAttributes() {
        return this.sinkParams.entrySet().stream().filter(e -> !((String)e.getKey()).contains("access_key")).collect(Collectors.toList()).toString();
    }

    public TPipeSinkInfo getTPipeSinkInfo() {
        return new TPipeSinkInfo(this.pipeSinkName, pipeSinkType.name()).setAttributes(this.sinkParams);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)((byte)pipeSinkType.ordinal()), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.pipeSinkName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.extPipeSinkTypeName, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.sinkParams, (OutputStream)outputStream);
    }

    public void deserialize(InputStream inputStream) throws IOException {
        this.pipeSinkName = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.extPipeSinkTypeName = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.sinkParams = ReadWriteIOUtils.readMap((InputStream)inputStream);
    }

    public void deserialize(ByteBuffer buffer) {
        this.pipeSinkName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.extPipeSinkTypeName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.sinkParams = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
    }

    public Map<String, String> getSinkParams() {
        return this.sinkParams;
    }

    public String getExtPipeSinkTypeName() {
        return this.extPipeSinkTypeName;
    }
}

