/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache.dualkeycache.impl;

import java.util.function.Function;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.ICacheSizeComputer;

class CacheSizeComputerImpl<FK, SK, V>
implements ICacheSizeComputer<FK, SK, V> {
    private final Function<FK, Integer> firstKeySizeComputer;
    private final Function<SK, Integer> secondKeySizeComputer;
    private final Function<V, Integer> valueSizeComputer;

    CacheSizeComputerImpl(Function<FK, Integer> firstKeySizeComputer, Function<SK, Integer> secondKeySizeComputer, Function<V, Integer> valueSizeCompute) {
        this.firstKeySizeComputer = firstKeySizeComputer;
        this.secondKeySizeComputer = secondKeySizeComputer;
        this.valueSizeComputer = valueSizeCompute;
    }

    @Override
    public int computeFirstKeySize(FK firstKey) {
        return this.firstKeySizeComputer.apply(firstKey);
    }

    @Override
    public int computeSecondKeySize(SK secondKey) {
        return this.secondKeySizeComputer.apply(secondKey);
    }

    @Override
    public int computeValueSize(V value) {
        return this.valueSizeComputer.apply(value);
    }
}

