<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# IoTDB Contributor Beginning
## Subscribe to the mailing list (dev@iotdb.apache.org)
The mailing list is the only communication channel that Apache designates for open source contributors. So try to make discussions on the mailing list as much as possible. The mailing list is essentially a mailbox. After subscription, all emails sent to this mailbox will be forwarded to the subscribed mailbox. The subscription method is as follows:

 1. Sending subscription email: Send an email to [dev-subscribe@iotdb.apache.org](dev-subscribe@iotdb.apache.org) with any subject you want.
 2. Confirming subscription: You will receive a subscription confirmation email from iotdb.apache.org after completing the previous step. Confirm your subscription by sending another email to this email with any subject matter.

## Create a development platform account

 1. Creating Jira account: [https://issues.apache.org/jira/projects/IOTDB/issues](https://issues.apache.org/jira/projects/IOTDB/issues) in order to claim issues.
 2. Creating Confluence account: [https://cwiki.apache.org/confluence/display/IOTDB/Home](https://cwiki.apache.org/confluence/display/IOTDB/Home) . It is then used to write design documents.

After creation, please send an email to the mailing list including **self introduction**, **Jira ID** and **Confluence ID**. The community PMC will add permissions to the account.

## Enter user/development chat group

 - QQ user group: 659990460
 - WeChat user group: IoTDB 数据库交流x群
 - Slack: [Apache IoTDB Community](https://join.slack.com/t/apacheiotdb/shared_invite/zt-qvso1nj8-7715TpySZtZqmyG5qXQwpg)

## Subscribe WeChat public account
Scan the QR code to subscribe official public account: Apache IoTDB
![IoTDB WeChat public account QR](https://user-images.githubusercontent.com/7240743/98633970-73671c00-235d-11eb-9913-f38e570fcfc8.png)

## Long term considerations
### Learn the basic use of IoTDB

 - [Download and Setup](https://iotdb.apache.org/UserGuide/Master/QuickStart/WayToGetIoTDB.html)
 - [IoTDB Quick Start](https://iotdb.apache.org/UserGuide/Master/QuickStart/QuickStart.html)
 - [Data Concept](https://iotdb.apache.org/UserGuide/Master/Data-Concept/Data-Model-and-Terminology.html)
 - [API](https://iotdb.apache.org/UserGuide/Master/API/Programming-Java-Native-API.html)

### Learn to debug IoTDB

 - [How to debug IoTDB server](https://my.oschina.net/u/3664598/blog/4500279)

### Understand the internal design of IoTDB

 - [IoTDB design documentation](https://cwiki.apache.org/confluence/display/IOTDB/Home)

### Find to-do tasks

 - [Resolve issues on Jira](https://issues.apache.org/jira/projects/IOTDB/issues)

