/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.recorder;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.engine.compaction.schedule.constant.ProcessChunkType;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class CompactionMetricsManager {
    private static final CompactionMetricsManager INSTANCE = new CompactionMetricsManager();
    private final AtomicInteger waitingSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishCrossCompactionTaskNum = new AtomicInteger(0);

    private CompactionMetricsManager() {
    }

    public static CompactionMetricsManager getInstance() {
        return INSTANCE;
    }

    public void recordWriteInfo(CompactionType compactionType, ProcessChunkType processChunkType, boolean aligned, long byteNum) {
        MetricService.getInstance().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + compactionType.toString(), Tag.TYPE.toString(), (aligned ? "ALIGNED" : "NOT_ALIGNED") + "_" + processChunkType.toString()});
        MetricService.getInstance().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    public void recordReadInfo(long byteNum) {
        MetricService.getInstance().count(byteNum, Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void updateSummary(CompactionTaskSummary summary) {
        MetricService.getInstance().count(summary.getProcessPointNum(), "Compacted_Point_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getProcessChunkNum(), "Compacted_Chunk_Num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getDirectlyFlushChunkNum(), "Directly_Flush_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getDeserializeChunkCount(), "Deserialized_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        MetricService.getInstance().count((long)summary.getMergedChunkNum(), "Merged_Chunk_Num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void reportAddTaskToWaitingQueue(boolean isCrossTask, boolean isSeq) {
        if (isCrossTask) {
            this.waitingCrossCompactionTaskNum.incrementAndGet();
        } else if (isSeq) {
            this.waitingSeqInnerCompactionTaskNum.incrementAndGet();
        } else {
            this.waitingUnseqInnerCompactionTaskNum.incrementAndGet();
        }
    }

    public void reportPollTaskFromWaitingQueue(boolean isCrossTask, boolean isSeq) {
        if (isCrossTask) {
            this.waitingCrossCompactionTaskNum.decrementAndGet();
        } else if (isSeq) {
            this.waitingSeqInnerCompactionTaskNum.decrementAndGet();
        } else {
            this.waitingUnseqInnerCompactionTaskNum.decrementAndGet();
        }
    }

    public void reportTaskStartRunning(boolean isCrossTask, boolean isSeq) {
        if (isCrossTask) {
            this.runningCrossCompactionTaskNum.incrementAndGet();
        } else if (isSeq) {
            this.runningSeqInnerCompactionTaskNum.incrementAndGet();
        } else {
            this.runningUnseqInnerCompactionTaskNum.incrementAndGet();
        }
    }

    public void reportTaskFinishOrAbort(boolean isCrossTask, boolean isSeq, long timeCost) {
        if (isCrossTask) {
            this.runningCrossCompactionTaskNum.decrementAndGet();
            this.finishCrossCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross_compaction"});
        } else if (isSeq) {
            this.runningSeqInnerCompactionTaskNum.decrementAndGet();
            this.finishSeqInnerCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        } else {
            this.runningUnseqInnerCompactionTaskNum.decrementAndGet();
            this.finishUnseqInnerCompactionTaskNum.incrementAndGet();
            MetricService.getInstance().timer(timeCost, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        }
    }

    public int getWaitingSeqInnerCompactionTaskNum() {
        return this.waitingSeqInnerCompactionTaskNum.get();
    }

    public int getWaitingUnseqInnerCompactionTaskNum() {
        return this.waitingUnseqInnerCompactionTaskNum.get();
    }

    public int getWaitingCrossCompactionTaskNum() {
        return this.waitingCrossCompactionTaskNum.get();
    }

    public int getRunningSeqInnerCompactionTaskNum() {
        return this.runningSeqInnerCompactionTaskNum.get();
    }

    public int getRunningUnseqInnerCompactionTaskNum() {
        return this.runningUnseqInnerCompactionTaskNum.get();
    }

    public int getRunningCrossCompactionTaskNum() {
        return this.runningCrossCompactionTaskNum.get();
    }

    public int getFinishSeqInnerCompactionTaskNum() {
        return this.finishSeqInnerCompactionTaskNum.get();
    }

    public int getFinishUnseqInnerCompactionTaskNum() {
        return this.finishUnseqInnerCompactionTaskNum.get();
    }

    public int getFinishCrossCompactionTaskNum() {
        return this.finishCrossCompactionTaskNum.get();
    }
}

