/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.db.mpp.plan.scheduler.IQueryTerminator;
import org.apache.iotdb.mpp.rpc.thrift.TCancelQueryReq;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryTerminator
implements IQueryTerminator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryTerminator.class);
    private static final long TERMINATION_GRACE_PERIOD_IN_MS = 1000L;
    protected ScheduledExecutorService scheduledExecutor;
    private final QueryId queryId;
    private final MPPQueryContext queryContext;
    private final IFragInstanceStateTracker stateTracker;
    private List<TEndPoint> relatedHost;
    private Map<TEndPoint, List<TFragmentInstanceId>> ownedFragmentInstance;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public SimpleQueryTerminator(ScheduledExecutorService scheduledExecutor, MPPQueryContext queryContext, List<FragmentInstance> fragmentInstances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager, IFragInstanceStateTracker stateTracker) {
        this.scheduledExecutor = scheduledExecutor;
        this.queryId = queryContext.getQueryId();
        this.queryContext = queryContext;
        this.internalServiceClientManager = internalServiceClientManager;
        this.stateTracker = stateTracker;
        this.calculateParameter(fragmentInstances);
    }

    private void calculateParameter(List<FragmentInstance> instances) {
        this.relatedHost = this.getRelatedHost(instances);
        this.ownedFragmentInstance = new HashMap<TEndPoint, List<TFragmentInstanceId>>();
        for (TEndPoint endPoint : this.relatedHost) {
            this.ownedFragmentInstance.put(endPoint, this.getRelatedFragmentInstances(endPoint, instances));
        }
    }

    @Override
    public Future<Boolean> terminate() {
        this.relatedHost = this.relatedHost.stream().filter(endPoint -> !this.queryContext.getEndPointBlackList().contains(endPoint)).collect(Collectors.toList());
        return this.scheduledExecutor.schedule(this::syncTerminate, 1000L, TimeUnit.MILLISECONDS);
    }

    public Boolean syncTerminate() {
        boolean succeed = true;
        for (TEndPoint endPoint : this.relatedHost) {
            List<TFragmentInstanceId> unfinishedFIs = this.stateTracker.filterUnFinishedFIs(this.ownedFragmentInstance.get(endPoint));
            if (unfinishedFIs.isEmpty()) continue;
            try {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);
                try {
                    client.cancelQuery(new TCancelQueryReq(this.queryId.getId(), unfinishedFIs));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (ClientManagerException e) {
                logger.warn("can't connect to node {}", (Object)endPoint, (Object)e);
                succeed = false;
            }
            catch (TException t) {
                logger.warn("cancel query {} on node {} failed.", new Object[]{this.queryId.getId(), endPoint, t});
                succeed = false;
            }
        }
        return succeed;
    }

    private List<TEndPoint> getRelatedHost(List<FragmentInstance> fragmentInstances) {
        return fragmentInstances.stream().map(instance -> instance.getHostDataNode().internalEndPoint).distinct().collect(Collectors.toList());
    }

    private List<TFragmentInstanceId> getRelatedFragmentInstances(TEndPoint endPoint, List<FragmentInstance> fragmentInstances) {
        return fragmentInstances.stream().filter(instance -> instance.getHostDataNode().internalEndPoint.equals(endPoint)).map(instance -> instance.getId().toThrift()).collect(Collectors.toList());
    }
}

