/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.driver.DataDriver;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.driver.Driver;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriver;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.Operator;

public class PipelineDriverFactory {
    private final DriverContext driverContext;
    private final Operator operation;
    private int dependencyPipelineIndex = -1;

    public PipelineDriverFactory(Operator operation, DriverContext driverContext) {
        this.operation = Objects.requireNonNull(operation, "rootOperator is null");
        this.driverContext = driverContext;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Driver createDriver() {
        Objects.requireNonNull(this.driverContext, "driverContext is null");
        try {
            Driver driver = null;
            driver = this.driverContext instanceof DataDriverContext ? new DataDriver(this.operation, this.driverContext) : new SchemaDriver(this.operation, (SchemaDriverContext)this.driverContext);
            if (this.dependencyPipelineIndex != -1) {
                driver.getDriverContext().setDependencyDriverIndex(this.dependencyPipelineIndex);
            }
            return driver;
        }
        catch (Throwable failure) {
            block5: {
                try {
                    this.operation.close();
                }
                catch (Throwable closeFailure) {
                    if (failure == closeFailure) break block5;
                    failure.addSuppressed(closeFailure);
                }
            }
            throw failure;
        }
    }

    public void setDependencyPipeline(int dependencyPipelineIndex) {
        this.dependencyPipelineIndex = dependencyPipelineIndex;
    }

    public int getDependencyPipelineIndex() {
        return this.dependencyPipelineIndex;
    }
}

