/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriverThread
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDriverThread.class);
    private final IndexedBlockingQueue<DriverTask> queue;
    private final ThreadProducer producer;
    protected final ITaskScheduler scheduler;
    private volatile boolean closed;

    protected AbstractDriverThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler, ThreadProducer producer) {
        super(tg, workerId);
        this.queue = queue;
        this.scheduler = scheduler;
        this.closed = false;
        this.producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.closed && !Thread.currentThread().isInterrupted()) {
                DriverTask next;
                try {
                    next = this.queue.poll();
                }
                catch (InterruptedException e) {
                    logger.warn("Executor {} failed to poll driver task from queue", (Object)this.getName());
                    Thread.currentThread().interrupt();
                    break;
                }
                if (next == null) {
                    logger.error("DriverTask should never be null");
                    continue;
                }
                try (SetThreadName driverTaskName = new SetThreadName(next.getDriverTaskId().getFullId());){
                    this.execute(next);
                }
                catch (Throwable t) {
                    try (SetThreadName driverTaskName2 = new SetThreadName(next.getDriver().getDriverTaskId().getFullId());){
                        logger.warn("[ExecuteFailed]", t);
                        next.setAbortCause("internal error scheduled");
                        this.scheduler.toAborted(next);
                    }
                }
            }
        }
        finally {
            if (!this.closed) {
                logger.warn("Executor {} exits because it's interrupted, and we will produce another thread to replace.", (Object)this.getName());
                this.producer.produce(this.getName(), this.getThreadGroup(), this.queue, this.producer);
            } else {
                logger.info("Executor {} exits because it is closed.", (Object)this.getName());
            }
        }
    }

    protected abstract void execute(DriverTask var1) throws InterruptedException, ExecutionException;

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

