/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema.source;

import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.read.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class PathsUsingTemplateSource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final List<PartialPath> pathPatternList;
    private final int templateId;

    PathsUsingTemplateSource(List<PartialPath> pathPatternList, int templateId) {
        this.pathPatternList = pathPatternList;
        this.templateId = templateId;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        return new DevicesUsingTemplateReader(this.pathPatternList.iterator(), schemaRegion);
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return ColumnHeaderConstant.showPathsUsingTemplateHeaders;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo device, TsBlockBuilder builder, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(device.getFullPath()));
        builder.declarePosition();
    }

    private class DevicesUsingTemplateReader
    implements ISchemaReader<IDeviceSchemaInfo> {
        final Iterator<PartialPath> pathPatternIterator;
        final ISchemaRegion schemaRegion;
        private Throwable throwable;
        ISchemaReader<IDeviceSchemaInfo> currentDeviceReader;

        DevicesUsingTemplateReader(Iterator<PartialPath> pathPatternIterator, ISchemaRegion schemaRegion) {
            this.pathPatternIterator = pathPatternIterator;
            this.schemaRegion = schemaRegion;
            this.throwable = null;
        }

        @Override
        public void close() throws Exception {
            if (this.currentDeviceReader != null) {
                this.currentDeviceReader.close();
            }
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.throwable != null) {
                    return false;
                }
                if (this.currentDeviceReader != null) {
                    if (this.currentDeviceReader.hasNext()) {
                        return true;
                    }
                    this.currentDeviceReader.close();
                    if (!this.currentDeviceReader.isSuccess()) {
                        this.throwable = this.currentDeviceReader.getFailure();
                        return false;
                    }
                }
                while (this.pathPatternIterator.hasNext()) {
                    this.currentDeviceReader = this.schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan(this.pathPatternIterator.next(), 0, 0, false, PathsUsingTemplateSource.this.templateId));
                    if (this.currentDeviceReader.hasNext()) {
                        return true;
                    }
                    this.currentDeviceReader.close();
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public IDeviceSchemaInfo next() {
            return (IDeviceSchemaInfo)this.currentDeviceReader.next();
        }

        @Override
        public boolean isSuccess() {
            return this.throwable == null && (this.currentDeviceReader == null || this.currentDeviceReader.isSuccess());
        }

        @Override
        public Throwable getFailure() {
            if (this.throwable != null) {
                return this.throwable;
            }
            if (this.currentDeviceReader != null) {
                return this.currentDeviceReader.getFailure();
            }
            return null;
        }
    }
}

