/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.IDataRegionForQuery;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceContext
extends QueryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceContext.class);
    private static final long END_TIME_INITIAL_VALUE = -1L;
    private final FragmentInstanceId id;
    private final FragmentInstanceStateMachine stateMachine;
    private IDataRegionForQuery dataRegion;
    private Filter timeFilter;
    private List<PartialPath> sourcePaths;
    private QueryDataSource sharedQueryDataSource;
    private Set<TsFileResource> closedFilePaths;
    private Set<TsFileResource> unClosedFilePaths;
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<Long> executionStartTime = new AtomicReference();
    private final AtomicReference<Long> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<Long> executionEndTime = new AtomicReference();
    private SessionInfo sessionInfo;

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter timeFilter) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo, dataRegion, timeFilter);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContextForCompaction(long queryId) {
        return new FragmentInstanceContext(queryId);
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter timeFilter) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataRegion = dataRegion;
        this.timeFilter = timeFilter;
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, new SessionInfo(1L, "test", ZoneId.systemDefault().getId()));
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public void setDataRegion(IDataRegionForQuery dataRegion) {
        this.dataRegion = dataRegion;
    }

    private FragmentInstanceContext(long queryId) {
        this.queryId = queryId;
        this.id = null;
        this.stateMachine = null;
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.lastExecutionStartTime.set(now);
    }

    private void initialize() {
        this.stateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    private void updateStatsIfDone(FragmentInstanceState newState) {
        if (newState.isDone()) {
            long now = System.currentTimeMillis();
            this.executionStartTime.compareAndSet(null, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.executionEndTime.compareAndSet(-1L, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
        }
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public void failed(Throwable cause) {
        this.stateMachine.failed(cause);
    }

    public String getFailedCause() {
        return this.stateMachine.getFailureCauses().stream().findFirst().map(Throwable::getMessage).orElse("");
    }

    public List<FragmentInstanceFailureInfo> getFailureInfoList() {
        return this.stateMachine.getFailureCauses().stream().map(FragmentInstanceFailureInfo::toFragmentInstanceFailureInfo).collect(Collectors.toList());
    }

    public void finished() {
        this.stateMachine.finished();
    }

    public void transitionToFlushing() {
        this.stateMachine.transitionToFlushing();
    }

    public void cancel() {
        this.stateMachine.cancel();
    }

    public void abort() {
        this.stateMachine.abort();
    }

    public long getEndTime() {
        return this.executionEndTime.get();
    }

    @Override
    public long getStartTime() {
        return this.executionStartTime.get();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return new FragmentInstanceInfo(this.stateMachine.getState(), this.getEndTime(), this.getFailedCause(), this.getFailureInfoList());
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.stateMachine.getFailureCauses().peek());
    }

    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public IDataRegionForQuery getDataRegion() {
        return this.dataRegion;
    }

    public void setSourcePaths(List<PartialPath> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initQueryDataSource(List<PartialPath> sourcePaths) throws QueryProcessException {
        if (sourcePaths == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            HashSet<String> selectedDeviceIdSet = new HashSet<String>();
            for (PartialPath path : sourcePaths) {
                PartialPath translatedPath = IDTable.translateQueryPath(path);
                pathList.add(translatedPath);
                selectedDeviceIdSet.add(translatedPath.getDevice());
            }
            this.sharedQueryDataSource = this.dataRegion.query(pathList, selectedDeviceIdSet.size() == 1 ? (String)selectedDeviceIdSet.iterator().next() : null, this, this.timeFilter != null ? this.timeFilter.copy() : null);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForQuery(this.sharedQueryDataSource);
            }
        }
        finally {
            this.dataRegion.readUnlock();
        }
    }

    public synchronized QueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        if (this.sharedQueryDataSource == null) {
            this.initQueryDataSource(this.sourcePaths);
        }
        return this.sharedQueryDataSource;
    }

    private void addUsedFilesForQuery(QueryDataSource dataSource) {
        this.addUsedFilesForQuery(dataSource.getSeqResources());
        this.addUsedFilesForQuery(dataSource.getUnseqResources());
    }

    private void addUsedFilesForQuery(List<TsFileResource> resources) {
        Iterator<TsFileResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            Set<TsFileResource> pathSet;
            TsFileResource tsFileResource = iterator.next();
            boolean isClosed = tsFileResource.isClosed();
            this.addFilePathToMap(tsFileResource, isClosed);
            if (!tsFileResource.isDeleted()) continue;
            Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
            if (pathSet.remove(tsFileResource)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            iterator.remove();
        }
    }

    private void addFilePathToMap(TsFileResource tsFile, boolean isClosed) {
        Set<TsFileResource> pathSet;
        Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
        if (!pathSet.contains(tsFile)) {
            pathSet.add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }

    protected synchronized void releaseResource() {
        for (TsFileResource tsFile : this.closedFilePaths) {
            FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
        }
        this.closedFilePaths = null;
        for (TsFileResource tsFile : this.unClosedFilePaths) {
            FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
        }
        this.unClosedFilePaths = null;
        this.dataRegion = null;
        this.timeFilter = null;
        this.sourcePaths = null;
        this.sharedQueryDataSource = null;
    }
}

