/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.basic.MeasurementTraverser;

public abstract class MeasurementCollector<R>
extends MeasurementTraverser<R> {
    protected MeasurementCollector(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected R generateResult(IMNode nextMatchedNode) {
        return this.collectMeasurement(nextMatchedNode.getAsMeasurementMNode());
    }

    protected abstract R collectMeasurement(IMeasurementMNode var1);

    protected MeasurementPath getCurrentMeasurementPathInTraverse(IMeasurementMNode currentNode) {
        IMNode par = (IMNode)this.getParentOfNextMatchedNode();
        MeasurementPath retPath = new MeasurementPath(this.getPartialPathFromRootToNode(currentNode), currentNode.getSchema());
        retPath.setUnderAlignedEntity(par.getAsEntityMNode().isAligned());
        return retPath;
    }
}

