/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser;

import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;

public class TraverserWithLimitOffsetWrapper<R>
extends Traverser<R> {
    private final Traverser<R> traverser;
    private final long limit;
    private final long offset;
    private final boolean hasLimit;
    private int count = 0;
    int curOffset = 0;

    public TraverserWithLimitOffsetWrapper(Traverser<R> traverser, long limit, long offset) {
        this.traverser = traverser;
        this.limit = limit;
        this.offset = offset;
        boolean bl = this.hasLimit = limit > 0L || offset > 0L;
        if (this.hasLimit) {
            while ((long)this.curOffset < offset && traverser.hasNext()) {
                traverser.next();
                ++this.curOffset;
            }
        }
    }

    public boolean hasNext() {
        if (this.hasLimit) {
            return (long)this.count < this.limit && this.traverser.hasNext();
        }
        return this.traverser.hasNext();
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.traverser.next();
        if (this.hasLimit) {
            ++this.count;
        }
        return (R)result;
    }

    @Override
    public void traverse() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    public boolean isSuccess() {
        return this.traverser.isSuccess();
    }

    public Throwable getFailure() {
        return this.traverser.getFailure();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(IMNode node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(IMNode node) {
        return false;
    }

    protected boolean acceptInternalMatchedNode(IMNode node) {
        return false;
    }

    protected boolean acceptFullMatchedNode(IMNode node) {
        return false;
    }

    protected R generateResult(IMNode nextMatchedNode) {
        return null;
    }

    @Override
    public void close() {
        this.traverser.close();
    }

    public void reset() {
        this.traverser.reset();
        this.count = 0;
        this.curOffset = 0;
        if (this.hasLimit) {
            while ((long)this.curOffset < this.offset && this.traverser.hasNext()) {
                this.traverser.next();
                ++this.curOffset;
            }
        }
    }

    public int getNextOffset() {
        return this.curOffset + this.count;
    }
}

